<%--
/****************************************************************/
/*                                                              */
/* ADOBE CONFIDENTIAL                                           */
/* _ _ _ _ _ _ _ _ _ _ _ _ _                                    */
/*                                                              */
/* Copyright [2010-2011] Adobe Systems Incorporated             */
/* All Rights Reserved.                                         */
/*                                                              */
/* NOTICE: All information contained herein is, and remains the */
/* property of Adobe Systems Incorporated and its suppliers, if */
/* any. The intellectual and technical concepts contained       */
/* herein are proprietary to Adobe Systems Incorporated and its */
/* suppliers and may be covered by U.S. and Foreign Patents,    */
/* patents in process, and are protected by trade secret or     */
/* copyright law. Dissemination of this information or          */
/* reproduction of this material is strictly forbidden unless   */
/* prior written permission is obtained from Adobe Systems      */
/* Incorporated.                                                */
/*                                                              */
/****************************************************************/

  ==============================================================================
  Draws the Event Registration Form.
  ==============================================================================
--%>
<%@ page import="java.util.Date, java.util.Calendar, java.util.GregorianCalendar, java.net.URLEncoder, com.day.cq.wcm.api.WCMMode, com.adobe.connect.osgi.util.*, java.text.MessageFormat" %>
<%@include file="/apps/connect/common.jsp" %>
<%
	String inputLabelCSS = ContentUtils.getCSSStyle(properties, "lbl", isIndependentCQInstance);
	request.setAttribute("registrationPageCSS", inputLabelCSS);
	
	String errTextCSS   = ContentUtils.getCSSStyle(properties, "err", isIndependentCQInstance);
	String notesTextCSS = ContentUtils.getCSSStyle(properties, "notes", isIndependentCQInstance);
	String bodyTextCSS = ContentUtils.getCSSStyle(properties, "body", isIndependentCQInstance);
	request.setAttribute("registrationPageBodyTextCSS", bodyTextCSS);

	String loginOk = xssUtilService.encodeForHTML(slingRequest.getParameter("login-ok"));
	String uri = loginOk;
	// if this parameter exist, an user has been forwarded to this page after successful login
	if(uri == null) {
	    uri = xssUtilService.getValidJSToken( slingRequest.getParameter("reg-form-back") );
	    // if this parameter exist, an user has been forwarded to this page after registration failure
	    if(uri == null) {
	        uri = currentPage.getPath() + ".html"; //request.getRequestURI();
	    }
	    
	}

	boolean regConfirmRedirect = false;
	String regConfirmUri = currentPage.getPath();
    regConfirmUri = regConfirmUri.substring(0, regConfirmUri.lastIndexOf("/")) + "/registration_confirm.html";
	
	String resultUri = uri.substring(0, uri.lastIndexOf('.')) + ".result" + uri.substring(uri.lastIndexOf('.'), uri.length());
	String accountId = getAccountId(currentNode, request, connectInfo, connectAPIService, isIndependentCQInstance);
	OmnitureAcountInfo omnitureAccountInfo; 
	try {
	    omnitureAccountInfo = connectAPIService.getOmnitureAccountInfo(accountId);
	} catch(ConnectServiceException ex) {
	    if ( ! FailureCode.API_ERROR.equals(ex.getErrorCode()) )
	    {
	        throw ex;
	    }
	    out.write(eventResBundle.getString("errConnectingToServer"));
	    return;
	}
	RegistrationAvailability registrationAvailability = null;
	
	EventInfo eventInfo = getEventInfo(request, currentNode, connectAPIService);
	String eventId = eventInfo != null ? eventInfo.getScoId() : null;
	
	
	//getting saml idp information
    Map<String, String> samlInfo = null;
	if(eventInfo != null)
		samlInfo = ConnectUtil.getSAMLIDPInformation(connectServer, null, eventInfo.getAccountId());
 	String oktaDomain = null;
 	String idpURL = null;
	if(samlInfo != null){
        oktaDomain = samlInfo.get("oktaDomain").toString();
        idpURL =  samlInfo.get("idpURL").toString();
 	}
	
	// check for IDP Auth Data
	IDPSocialProfile socialProfile = ConnectUtil.getIDPAuthData(request); 
	boolean idpAuth = socialProfile != null;
	request.setAttribute("idpAuth", idpAuth);	
			
	// check for preview parameter
	String previewParam = xssUtilService.getValidJSToken(slingRequest.getParameter("preview"));
	boolean isPreview = "true".equals(previewParam);	
	request.setAttribute("isPreview", isPreview);

	//retrieving event registration fields
	List<EventField> eventFieldList = null;	
	//if attribute 'event-field-list' exists, an user has been forwarded to this page after successful login
	Object obj = request.getAttribute("event-field-list");
	if (obj != null) {
		eventFieldList = (List<EventField>) obj;
	} else if (eventId != null) {		
		eventFieldList = connectAPIService.getEventFields(eventId,
				isPreview, idpAuth);		
	}

    // we show different strings to the user depending if there are any fields to edit
    boolean hasEditableFields = false;
    if(eventFieldList != null && !eventFieldList.isEmpty()) {           
        EventField eventField = null;
        for(int i = 0; i < eventFieldList.size(); i++) {
            eventField = eventFieldList.get(i);          
            if (  ! "login".equals(eventField.getName()) && ! "first-name".equals(eventField.getName()) && ! "last-name".equals(eventField.getName()) && ! "session".equals(eventField.getName()) && ! "tracking-id".equals(eventField.getInteractionType())  ) {
                hasEditableFields = true;
                break;
            }
        }
    }
	
	// link to login form
	String loginUri = null;
	if (isPreview || eventId == null) {
		loginUri = "javascript:void(0);";
	} else {
		loginUri = uri.substring(0, uri.lastIndexOf('.')) + ".login"
				+ uri.substring(uri.lastIndexOf('.'), uri.length())
				+ "?login-ok=" + uri + "&sco-id=" + eventId;
	}

	String connectLogin = null;
	if (isIndependentCQInstance && connectSessionId != null) {
		Map<String, Object> loggedInUser = ConnectUtil
				.getLoggedInConnectUserInfo(connectServer,
						connectSessionId);
		if (null != loggedInUser) {
			connectLogin = (String) loggedInUser.get("login");
		}
	} else {
		if (idpAuth) {	
			connectLogin = socialProfile.getAttribute("email");
		} else {
			connectLogin = (String) request
					.getAttribute("connect-login");
		}
	}

	String responseCode = (String) slingRequest.getAttribute("code");
	String responseSubcode = (String) slingRequest.getAttribute("subcode");	

	if (eventId != null) {
		if (("no-access".equals(responseCode) && "cancelled"
				.equals(responseSubcode))
				|| "cancelled".equals(eventInfo.getEventStatus())) {
		%><div class="event_reg_info_err_msg" <%= errTextCSS %>><%= eventResBundle.getString("errMsgEventCancelled") %></div><%
		        return;
	    }
				
		
	    if(eventInfo.getName() == null) // Still no information
	    {
	        %><div class="event_reg_info_err_msg" <%= errTextCSS %>><%= eventResBundle.getString("eventNotPublished") %></div><%   
	        return;
	    }
	    if((eventInfo.isRegistrationLimitEnabled() && eventInfo.getNumberRegisteredUsers() >= eventInfo.getRegistrationLimit()) || ( "no-access".equals(responseCode) && "limit-reached".equals(responseSubcode) ) )   // Registration limit reached
	    {
	        %><div class="event_reg_info_err_msg" <%= errTextCSS %>><%= properties.get("regLimitLblField", "Registration limit reached. Unable to register new users.").toString() %></div><%
	        return;
	    }
	
	    registrationAvailability = ConnectUtil.eventRegistrationAvailability(eventInfo);
		
		if (!RegistrationAvailability.CAN_JOIN.equals(registrationAvailability)) {
			String registrationSuccessCustomization = properties.get("registrationSuccessCustomization", "customMessage");
			if (! "customMessage".equals(registrationSuccessCustomization) ) {
				regConfirmRedirect = true;
			}
		}
	
	    if (RegistrationAvailability.TOO_LATE.equals(registrationAvailability))
	    {           
	        %><div class="event_reg_info_err_msg" <%= errTextCSS %>><%= eventResBundle.getString("tooLateRegistration") %></div><%
	        return;
	    }
	    else if(RegistrationAvailability.NOT_STARTED.equals(registrationAvailability))
	    {
	        Calendar beginDateCal = ConnectUtil.parseDate(eventInfo.getBeginDate());                        
	
	        %> 
	        	<div class="event_reg_info_err_msg" <%= errTextCSS %>><%= eventResBundle.getString("tooEarlyRegistration") %> 
	            	<%= ConnectUtil.getLocalizedCalendarString(beginDateCal, ConnectUtil.getLocale(pageLanguagePreference)) %>
	            </div>
	        <%
	        
	        return;
	        
	    }   
	   	else if(idpAuth == false && connectSessionId != null && !isPreview)
	    {    
	   		String redirectToResource = currentPage.getPath() + ".html?sco-id=" + eventId;
	   		
	    	String logoutLink;
	    	if ( isIndependentCQInstance ) {
	    	    logoutLink = "<a href=\"javascript: logoutConnect(true);\">" + eventResBundle.getString("logout") + "</a>";
	    	} else {
	    	    logoutLink = ConnectUtil.getLogoutLink(slingRequest, request, redirectToResource, connectServer, eventResBundle);
	    	}    	
	               
	        if(false) // TODO Check if the logged in user is an event manager
	        {
	            %> <div class="event_reg_info_msg" <%= notesTextCSS %>><%= MessageFormat.format ( eventResBundle.getString("eventManagerCannotRegister"), connectLogin, logoutLink )%></div> <%
	        }
	        else
	        {
	            %> <div class="event_reg_info_msg" <%= notesTextCSS %>><%= MessageFormat.format ( eventResBundle.getString("loggedInAsUser"), connectLogin, logoutLink )%></div> <%
	        }
	    }   
	   	else if(idpAuth == true && !isPreview && hasEditableFields == true)
	    {
	    	 %> <div class="event_reg_info_msg" <%= notesTextCSS %>><%= eventResBundle.getString("eventCompleteYourRegistrationMessage")%></div> <%
	    	
	    }
	    else if (null != loginOk) {
	    	String msgStr = hasEditableFields ? "eventRegistrationLoggedInAsUser1" : "eventRegistrationLoggedInAsUser2";
	        
	        %><div style="width: 740px;">          
	            <div class="event_reg_info_msg" <%= notesTextCSS %>><%= MessageFormat.format ( eventResBundle.getString(msgStr), (String) request.getAttribute("reg-login") )%></div> 
	          </div><%
	    }
	    
	    boolean hideClickHereMessage = eventInfo.isPasswordBypass() && "guest".equals(eventInfo.getEventGuestPolicy());
	    if(!hideClickHereMessage && (connectSessionId == null || isPreview) &&  loginOk == null && idpAuth == false )
	    {
	        %><div class="event_reg_info_msg" <%= notesTextCSS %>><%= MessageFormat.format ( eventResBundle.getString("eventRegistrationLoginLink"), loginUri) %></div>
	        <%
	    }
	  
	    if(idpAuth == false) {
	    	%><div class="event_reg_info_msg" <%= notesTextCSS %>><%= eventResBundle.getString("noteEventRegistrationMandatoryFields") %></div><%
	    }
	}
	else {
	%>
	    <div class="event_reg_label" <%= notesTextCSS %>><%= eventResBundle.getString("eventRegistrationEventIdMissing") %></div>
	<%
		return;
	}
	%>  

    <div style="clear:both"></div>
    
    <% if (idpAuth && hasEditableFields == false) {    
      %>
        <div style="margin-top:10px;width:100%;float:left;">
         <span class="event_reg_info_msg" <%= notesTextCSS %>><%= eventResBundle.getString("eventCompleteYourRegistrationTitle") %></span>         
      <%      
    } else if (idpAuth == false){
        //negative right margin is added to style to make room for idpLink.jsp 	
      %>
        <div class="event_registration_form_top" style="width:100%;float:left;margin-right:-165px">         
         <span class="event_reg_info_msg" <%= notesTextCSS %>><%= eventResBundle.getString("eventRegisterWithEmail") %></span>        
      <%      
    } 
    %>

         <div class="event_registration_form">
           <% if (idpAuth == true) { 
              String name = socialProfile.getAttribute("first-name") + " " + socialProfile.getAttribute("last-name");
              // making name not wrappable
              name = name.replaceAll(" ", "&nbsp;");
              String social = socialProfile.getAttribute("idp-source").toLowerCase();
              String socialLink = "https://" + social + ".com";
              String socialFriendly = social.substring(0,1).toUpperCase() + social.substring(1);
                           
	             if (socialProfile.containsAttribute("picture")) { %>     
	                <div style="width:100%;overflow: auto;">   
	                   <div style="float:left;padding-right: 10px;">
	                       <a href="<%=socialLink%>">
                           		<img src="<%=socialProfile.getAttribute("picture")%>" width="50px" height="50px" style="border: none" >
                           </a>
	                   </div>
	                   <div class="event_reg_info_msg" style="margin-top:5px;">
	                       <a style="text-decoration:none;" href="<%=socialLink%>"><span class="social_username"> <%=name%> </span> </a> 
	                   </div>
	               </div>               
	         <% } else { %>
	            <div class="event_reg_info_msg" style="width:100%;">
	                  <%= eventResBundle.getString("eventRegistrationIDPLoggedInAsUser")%>  <a style="text-decoration:none;" href="<%=socialLink%>"><span class="social_username"> <%=name%> </span> </a> 
	            </div>                   
	         <% } %>               
             <div style="clear:both"></div>   
             <div class="event_reg_info_msg not_you_msg">
                 <%= MessageFormat.format ( eventResBundle.getString("incorrectIDPUser"), socialLink, socialFriendly, ConnectUtil.removeQueryParameter(slingRequest, "idp-data", socialProfile.getIdpData()))%>                    
             </div>
             <div style="clear:both; margin-bottom:10px"></div>
        <% } %>
        
	    <% String actionUrl = "/content/connect/connect-action?sco-id=" + eventId;  %>     
	    <form id="eventReg" method="post" action="<%= actionUrl %>">
	    
	    <% 
	        // render custom fields
	        if(eventFieldList != null && !eventFieldList.isEmpty()) {                       
	            EventField eventField = null;
	            for(int i = 0; i < eventFieldList.size(); i++) {
	                eventField = eventFieldList.get(i);                
	                request.setAttribute("eventField", eventField);                
	                boolean isHidden = "true".equals(eventField.getIsRequired()) && idpAuth && socialProfile.containsAttribute(eventField.getName());
                    if (isHidden) {  %>                    
                         <input type="hidden" name="<%=eventField.getName()%>" value="<%= socialProfile.getAttribute(eventField.getName()) %>" />
                    <%
                     } else {                      
                     %>
                         <cq:include script="<%= eventField.getHtml() %>"/>
    
                     <%
                     }
	                if("session".equals(eventField.getName())) {
	                    // Add login and password as hidden fields.
	                    // This hidden fields will be read by FetchEventFields action and sent to Connect API.
	                    // Connect API will return interaction fields only. Otherwise it will return both
	                    // user fields and interaction fields.
	                    %>
	                        <input name="login" type="hidden" value="<%= slingRequest.getParameter("login") != null ? xssUtilService.encodeForHTMLAttr(slingRequest.getParameter("login")) : connectLogin %>"/>
	                        <% if ( null != slingRequest.getParameter("password") ) { %>
	                                <input name="password" type="hidden" value="<%= xssUtilService.encodeForHTMLAttr(slingRequest.getParameter("password")) %>"/>
	                        <% } %>
	                    <%
	                }
	            }
	        }
	        %>
	        
	        <%-- message error handling --%>
	        <%
	        if(responseCode != null) {                  
	            if("no-data".equals(responseCode)) { %> 
	                <h4 id="errorMsg1" <%= errTextCSS %>><%= eventResBundle.getString("eventRegistrationNodata") %></h4>
	            <%
	            } else if("invalid".equals(responseCode)){
	                String reasonField = (String)slingRequest.getAttribute("reasonfield");                  
	                if("not-allowed".equals(responseSubcode) && "already-registered".equals(reasonField)) {
	                	%> <br /><div class="event_reg_info_err_msg" <%= errTextCSS %>><%= eventResBundle.getString("errMsgAlreadyRegistered") %></div> <% 
	                 } else if( ( "range".equals(responseSubcode))  ||
							("password-requires-special-chars".equals(responseSubcode)) ||
							("password-requires-capital-letter".equals(responseSubcode)) || 
							("password-requires-digit".equals(responseSubcode))) { 
							
							String hint = xssUtilService.encodeForHTML(request.getParameter("passwordHint"));
                            hint = hint.replace("&lt;br&#x2f;&gt;", "<br/>");
                            hint = hint.replace("&lt;br&gt;", "<br/>");
							%>
						<br /><div class="event_reg_info_err_msg" <%= errTextCSS %>><%= hint %></div>
	                <% } else if("format".equals(responseSubcode)) { %>
	                    <br /><div class="event_reg_info_err_msg" <%= errTextCSS %>><%= MessageFormat.format ( eventResBundle.getString("invalidInput"), request.getAttribute("reasonfield")) %></div> 
	                <% } else if ("no-access".equals(responseSubcode)) { %>
	                    <br /><div class="event_reg_info_err_msg" <%= errTextCSS %>><%= MessageFormat.format ( eventResBundle.getString("errMsgChangePasswordRequestPending"), request.getAttribute("changePasswordReqUrl")) %></div> 
	                <% } else if (responseSubcode == null) { %>
                    	<br /><div class="event_reg_info_err_msg" <%= errTextCSS %>><%= eventResBundle.getString("eventRegistrationLoginFailure") %></div> 
                	<% }
	            %>
	            <%
	            } else if("no-access".equals(responseCode)){                
	                %>
	                <div id="errorMsg1" class="event_reg_info_err_msg" <%= errTextCSS %>><%= eventResBundle.getString("eventRegistrationNoAccess") %></div>
	                <%
	                if("no-login".equals(responseSubcode)) { %>
	                    <h4 id="errorMsg2"><div class="event_reg_info_err_msg" <%= errTextCSS %>><%= eventResBundle.getString("eventRegistrationUnpublished") %></div></h4>
	                <%
	                } else if("sco-expired".equals(responseSubcode)) { %>
	                    <h4 id="errorMsg2"><div class="event_reg_info_err_msg" <%= errTextCSS %>><%= eventResBundle.getString("eventRegistrationEnded") %></div></h4>
	                <%
	                } else {
	                %>
	                    <div id="errorMsg2" class="event_reg_info_err_msg" <%= errTextCSS %>><%= MessageFormat.format ( eventResBundle.getString("unknownErrorCode"), responseSubcode )%></div>
	                <% 
	                }
	            } else {                
	                %>                
	                <%
	                if("duplicate".equals(responseSubcode)) { %>
	                    <div id="errorMsg2" class="event_reg_info_err_msg" <%= errTextCSS %>><%= eventResBundle.getString("eventRegistrationDuplicate") %></div>
	                <%
	                } else if("missing".equals(responseSubcode)) { %>
	                    <div id="errorMsg2" class="event_reg_info_err_msg" <%= errTextCSS %>><%= eventResBundle.getString("eventRegistrationMissing") %></div>
	                <%
	                } else if("range".equals(responseSubcode)) { %> 
	                    <div id="errorMsg2" class="event_reg_info_err_msg" <%= errTextCSS %>><%= eventResBundle.getString("eventRegistrationPasswordRange") %></div>
	                <%
	                } else if("password-requires-special-chars".equals(responseSubcode)) { %>
	                    <div id="errorMsg2" class="event_reg_info_err_msg" <%= errTextCSS %>><%= eventResBundle.getString("eventRegistrationPasswordChar") %></div>
	                <%
	                } else if ("password-requires-capital-letter".equals(responseSubcode)) { %>
	                    <div id="errorMsg2" class="event_reg_info_err_msg" <%= errTextCSS %>><%= eventResBundle.getString("eventRegistrationPasswordCapitalLetter") %></div>
	                <%
	                } else if ("password-requires-digit".equals(responseSubcode)) { %>
	                    <div id="errorMsg2" class="event_reg_info_err_msg" <%= errTextCSS %>><%= eventResBundle.getString("eventRegistrationPasswordNumber") %></div>
	                <%
	                } else {
	                %>
	                    <div id="errorMsg2" class="event_reg_info_err_msg" <%= errTextCSS %>><%= MessageFormat.format ( eventResBundle.getString("unknownErrorCode"), responseSubcode )%></div>
	                <% 
	                }
	            }
	        }
	        %>       
	        
	        
	        <div id="firstLastName_errorMessage" class="event_reg_info_err_msg"></div>
	        <br>

	        <% if (WCMMode.fromRequest(request) != WCMMode.DISABLED) { %>
	            <div class="event_reg_info_msg" <%= notesTextCSS %>><%= eventResBundle.getString("registrationConfirmationMsgTip") %></div><br />
	        <% } %>
	        <a id="submitRegistrationFormLink" class="roundCornerButtonLink" onclick="regFormSubmit();" href="javascript:">
	            <span class="leftBtnImg">&nbsp;</span>
	            <span class="centerBtnImg">
	                <div style="vertical-align: middle; padding-top: 4px;">            
	                <%
	                if(RegistrationAvailability.SUBMIT.equals(registrationAvailability) || eventId == null)
	                {
	                %>
	                    <%= eventResBundle.getString("submitButtonLabel") %> 
	                <%
	                }
	                else if (eventInfo.getEventCategory().equals(Event.EventCategory.ONDEMAND)) 
	                {
	                %>
	                    <%= eventResBundle.getString("viewBtnLbl") %> 
	                <%
	                }
	                else if(RegistrationAvailability.CAN_JOIN.equals(registrationAvailability))
	                {
	                %>
	                    <%= eventResBundle.getString("joinBtnLbl") %>        
	                <%
	                }
	                
	                %>                              
	                </div>
	              </span>
	              <span class="rightBtnImg">&nbsp;</span>
	        </a>        
	        <%
	        if (previewParam != null && previewParam.equals("true") || eventId == null)
	        { 
	        %>
	            <script>
	               document.getElementById("submitRegistrationFormLink").onclick="#";
	               document.getElementById("submitRegistrationFormLink").style.color="#dedede";
	            </script>    
	        <%
	        }
	        %>        
	        <span style="float:left">&nbsp;&nbsp;</span>
	        <% 
	        if (idpAuth == false) { 
	        %>
	            <a id="submitRegistrationFormResetLink" class="roundCornerButtonLink" onclick="regReset();" href="javascript:">
		            <span class="leftBtnImg">&nbsp;</span>
		            <span class="centerBtnImg">	            
		            	<div style="vertical-align: middle; padding-top: 4px;"><%= eventResBundle.getString("resetButtonLabel") %></div>	            
	            	</span>
		            <span class="rightBtnImg">&nbsp;</span>
		        </a>         
	        <%
	        }
	        %>
	         
	        <div style="clear: both;">&nbsp;</div>  
	        <input name="sco-id" type="hidden" value="<%= eventId %>"/>
	        <input name="reg-form-back" type="hidden" value="<%= uri %>"/>
	        <input name="reg-form-success" type="hidden" value="<%= resultUri %>"/>
	        <input name="action" type="hidden" value="event-register" />
	        <input name="_charset_" type="hidden" value="UTF-8" />
	        <input name="login-uri" type="hidden" value="<%= loginUri %>" />
			<input name="set-lang" type="hidden" value="<%= pageLanguagePreference %>" />
			<% if (idpAuth) { %>
				<input name="idp-source" type="hidden" value="<%= socialProfile.getAttribute("idp-source") %>" />
			<% } %>		
			<% if(idpAuth && socialProfile.containsAttribute("token")) { %>
				<input name="token" type="hidden" value="<%= socialProfile.getAttribute("token") %>" />
			<% } %>
			<% if(regConfirmRedirect) { %>
				<input name="reg-confirm-page" type="hidden" value="<%= regConfirmUri %>" />
			<% } %>	
	        </form>
	        
	        <% if (idpAuth) { %>
				 <div style="width:100%;">
                     <span class="event_reg_info_msg" <%= notesTextCSS %>>
                         <%= MessageFormat.format ( eventResBundle.getString("otherRegistrationOptionsLabel"), ConnectUtil.removeQueryParameter(slingRequest, "idp-data", socialProfile.getIdpData()))%>
                     </span>
             	</div>
			<% } %>		
	        
        </div>
    </div>
        
   
  	<%@include file="idpLink.jsp" %>
  	
  	<div style="clear: both;"></div>  
        
            <script type="text/javascript"> 

            if (CQ.Ext) {
				CQ.Ext.onLoad(function(){
					
					makePwdHintPopup();
					
				});
            } else {
				jQuery(document).ready(function() {
										makePwdHintPopup();
									   }
									  );
			}
			$(window).keyup(function (e) {
				var code = (e.keyCode ? e.keyCode : e.which);
				if (code == 9 && $('#password_hint:focus').length) {
					jQuery(".event_reg_pwd_rules_msg").css({visibility:"visible",opacity:"1"});
				}
				else {
					jQuery(".event_reg_pwd_rules_msg").css({visibility:"hidden",opacity:"0"});
				}
			});
            function regFormSubmit() 
            {
                          
              var validationMessage = '';
              <% if ( null != eventId ) { %> 
                  var campaign = document.getElementById("campaign-id");
                  if(campaign !== undefined && campaign !== null) 
                  {
                      var campaignCookie = getCampaignCookie("<%= eventId %>");
                      if(campaignCookie !== undefined && campaignCookie !== null) 
                      {
                          campaign.value = campaignCookie;    
                      }   
                  }
              <% } %>              
              var form = document.getElementById("eventReg");
              if (validateReg(form) && validateFirstLastName()) 
              {  
					if(redirectIDPServer()){
						form.submit();
						return true;
					}
              }
              return false;
            }
            
            window.onload=onRegistrationPageLoad;
            function onRegistrationPageLoad()
            {
				var ar = document.getElementById("errMsgAlreadyRegistered")
				if (ar !== 'undefined' && ar !== null) {
					ar.style.display = "inline";
				}
				
				window.setTimeout(function() {
					// set focus to first form field
					var regForm = document.getElementById("eventReg");
					setFormFieldFocus(regForm);
				}, 500);
                
                <%
                    if(omnitureAccountInfo.getIsInUse() && omnitureAccountInfo.getReportSuiteId()!=null && eventInfo !=null && eventInfo.getName()!=null)
                    {
                %>
                    
                    var omnitureReportSuiteId ="<%= ConnectUtil.escapeJavaScript(omnitureAccountInfo.getReportSuiteId()) %>";
                    var omnitureVisitorNamespace ="<%= ConnectUtil.escapeJavaScript(omnitureAccountInfo.getVisitorNamespace()) %>";
                    var omnitureTrackingServer ="<%= ConnectUtil.escapeJavaScript(omnitureAccountInfo.getTrackingServer()) %>";
                    createOmnitureReportingTracker(omnitureReportSuiteId,omnitureVisitorNamespace,omnitureTrackingServer);
                    var campaign = "";
                    <% if ( null != eventId ) { %>
                        campaign = getCampaignCookie("<%= eventId %>");
                        if(campaign == undefined || campaign == null)
                        {
                            campaign = "";
                        }
                    <% } %>
                    var scoNameSignature = "<%= ConnectUtil.escapeJavaScript(eventInfo.getSCTrackingScoNameSignature()) %>";
                    pushRegistrationPageViewEvent(scoNameSignature,campaign);
                    
                <%  
                    }
                %>                
            }
			
						
			var emailAddress = document.querySelector("input[name=login]");
			
			function redirectIDPServer(){
				try{
					var oktadomain = "<%= oktaDomain %>";
					var oktaloginurl= "<%= idpURL %>" ;
					var loginAttributes = $("input[name=login]");
					if(loginAttributes.attr("type") == "hidden") // case when registration form is hidden
						return true;
						
					var loginName = loginAttributes.val();	
					
					// multi domain lists separated by Semicolon
    				var multiDomainNames = oktadomain.split(';');
					
					if(oktadomain != "null"){
						for(var i =0 ;i < multiDomainNames.length ;i++){
							if(loginName.indexOf(multiDomainNames[i]) !== -1){
								var scoID= <%= eventInfo.getScoId() %>;
								var relayState='{"action":"EVENT_REGISTRATION","scoID":'+scoID.toString()+'}';
								window.location = makeSSOLoginUrl(oktaloginurl, relayState);
								return false;
							}
						}
					}
				}
				catch(err){}
                return true;
    		}
			
			// function to construct sso login url based on template
			function makeSSOLoginUrl(oktaLoginURL, relayState ){
				var ssoLoginUrl = "";
				if(oktaLoginURL.indexOf('{$') == -1){
					ssoLoginUrl = makeDefaultSSOLoginUrl(oktaLoginURL, relayState);
				}        
				else
					ssoLoginUrl = oktaLoginURL.replace("{$RELAYSTATE}", encodeURIComponent(relayState));
				return ssoLoginUrl;
			}
			
				
			function makeDefaultSSOLoginUrl (oktaLoginURL, relayState){
				var ssoLoginUrl = "";
				if(oktaLoginURL.indexOf('?') == -1)
					ssoLoginUrl = oktaLoginURL + "?RelayState=" + encodeURIComponent(relayState);
				else
					ssoLoginUrl = oktaLoginURL + "&RelayState=" + encodeURIComponent(relayState);
				return ssoLoginUrl;
			}

			emailAddress.addEventListener( 'blur', redirectIDPServer);
            
          
            
          

        </script>                 
