<%@ page import="java.text.MessageFormat" %>
<%@include file="/apps/connect/common.jsp" %>


<%
    String inputLabelCSS = ContentUtils.getCSSStyle(properties, "lbl", isIndependentCQInstance);
    request.setAttribute("registrationPageCSS", inputLabelCSS);
    String errTextCSS   = ContentUtils.getCSSStyle(properties, "err", isIndependentCQInstance);
    String notesTextCSS = ContentUtils.getCSSStyle(properties, "notes", isIndependentCQInstance);


    EventInfo eventInfo = getEventInfo(request, currentNode, connectAPIService);
    String eventId = eventInfo != null ? eventInfo.getScoId() : null;

    // getting saml idp information
    Map<String, String> samlInfo = null;
    if(eventInfo != null)
        samlInfo = ConnectUtil.getSAMLIDPInformation(connectServer, null, eventInfo.getAccountId());
    String scoID = null;
    try{
        scoID = eventInfo.getScoId();
    }catch(Exception e){}
    
    String oktaDomain = null;
    String idpURL = null;
    if(samlInfo != null){
        oktaDomain = samlInfo.get("oktaDomain").toString();
        idpURL =  samlInfo.get("idpURL").toString();
    }

    String userLogin = xssUtilService.encodeForHTML(slingRequest.getParameter("login"));
    String forgotPwdPage = xssUtilService.filter(slingRequest.getParameter("forgot-password"));
    if(forgotPwdPage == null) {
        // link to the registration form page
        String regPage = xssUtilService.filter(slingRequest.getParameter("login-ok"));
		if(regPage != null){		
			// make a link to forgot password page
			forgotPwdPage = regPage.substring(0, regPage.lastIndexOf('.')) + ".forgotpassword" + regPage.substring(regPage.lastIndexOf('.'), regPage.length())
				+ "?login-link=" + slingRequest.getRequestURI() + "&sco-id=" + eventId + "&login-ok="
				+ xssUtilService.filter(slingRequest.getParameter("login-ok"));
		}
    }

%>


 	 <%
	 if(userLogin != null && slingRequest.getAttribute("error-code") == null)
	 {
	 %>
		 <div class="cq-colctrl-lt1-c0">
			<div class="event_reg_info_err_msg" <%= errTextCSS %>><%= MessageFormat.format(eventResBundle.getString("eventRegistrationLoginHeaderErrorMessage"), userLogin) 	%></div>    
		 </div>
	 <%
	 }else {
	 %>
		 <div class="cq-colctrl-lt1-c0">
			<div class="event_reg_info_msg" <%= notesTextCSS %>><%= eventResBundle.getString("eventRegistrationLoginHeader") %></div>
		 </div>
	 <%
	 }
	 %>
    

<div class="container" style="width: 740px;">
<form id="regLoginForm" name="input" action="/content/connect/connect-action" method="post">
    <br/>
	<label for="regLogin" class="event_reg_label" <%= inputLabelCSS %>><%= eventResBundle.getString("loginLabel") %></label><span style="color:red;">*</span><br/>
    <input id="regLogin" type="text" name="login" onblur="redirectIDPServer()" value="<%= slingRequest.getParameter("login") != null ? xssUtilService.encodeForHTML( slingRequest.getParameter("login")) : "" %>" class="event_reg_field" onKeyPress="return checkSubmit(event, regLoginSubmit)" aria-required="true" required/>
    <br/><span id="login_errorMessage" class="error_msg_registration"></span>

    <br/>
	<label for="regPwd" class="event_reg_label" <%= inputLabelCSS %>><%= eventResBundle.getString("passwordLabel") %></label><span style="color:red;">*</span><br/>
    <input id="regPwd" type="password" name="password" value="<%= slingRequest.getParameter("password") != null ? xssUtilService.encodeForHTML(slingRequest.getParameter("password")) : "" %>" class="event_reg_field" onfocus="this.select();" onKeyPress="return checkSubmit(event, regLoginSubmit)" aria-required="true" required/>
    <br/><span id="password_errorMessage" class="error_msg_registration"></span>
    <br>

    <%-- message error handling --%>

    <div id="errorMsg" class="event_reg_info_err_msg" <%= errTextCSS %>>
        <%
        if(slingRequest.getAttribute("error-code") != null) {
            String responseCode = (String)slingRequest.getAttribute("error-code");
            String responseSubCode = (String)slingRequest.getAttribute("error-subcode");
            if ("invalid".equals(responseCode) && "no-access".equals(responseSubCode)) { %>
                <br /><div class="event_reg_info_err_msg" <%= errTextCSS %>><%= MessageFormat.format ( eventResBundle.getString("errMsgChangePasswordRequestPending"), request.getAttribute("changePasswordReqUrl")) %></div> 
            <% } 
			else if(!"ok".equals(responseCode)) { %> 
                <%= eventResBundle.getString("eventRegistrationLoginFailure") %>
         <%
            }
        }
        %>
    </div>
    
    <br>
    <a class="roundCornerButtonLink" onclick="javascript:regLoginSubmit();" href="javascript:">
        <span class="leftBtnImg">&nbsp;</span>
        <span class="centerBtnImg">
            <div style="vertical-align: middle; padding-top: 4px;"><%= eventResBundle.getString("continueButtonLabel") %></div>
        </span>
        <span class="rightBtnImg">&nbsp;</span>
    </a>
    <span style="float:left">&nbsp;&nbsp;</span>
    <a class="roundCornerButtonLink" onclick="javascript:regLoginCancel('<%= xssUtilService.encodeForHTML(slingRequest.getParameter("login-ok")) %>?sco-id=<%= eventId %>');" href="javascript:">
        <span class="leftBtnImg">&nbsp;</span>
        <span class="centerBtnImg">
            <div style="vertical-align: middle; padding-top: 4px;"><%= eventResBundle.getString("cancelButtonLabel") %></div>
        </span>
        <span class="rightBtnImg">&nbsp;</span>
    </a> 
    <div style="clear: both;">&nbsp;</div>  
    <div class="event_reg_info_msg" <%= notesTextCSS %>><a href="<%= forgotPwdPage %>"><%= properties.get("forgotPasswordLblField", "Forgot your password?").toString() %></a></div>

    <input name="action" type="hidden" value="event-registration-details" />
    <input name="login-ok" type="hidden" value="<%= xssUtilService.encodeForHTML(slingRequest.getParameter("login-ok")) %>"/>
    <input name="login-failure" type="hidden" value="<%= slingRequest.getParameter("login-failure") != null ? xssUtilService.encodeForHTML( slingRequest.getParameter("login-failure")) : request.getRequestURI() %>"/>
    <input name="sco-id" type="hidden" value="<%= eventId %>"/>
    <input name="forgot-password" type="hidden" value="<%= forgotPwdPage %>"/>
    <input name="_charset_" type="hidden" value="UTF-8" />
    <input name="set-lang" type="hidden" value="<%= pageLanguagePreference %>" />
    <script type="text/javascript">
        window.onload=onEventRegLoad('regLoginForm');


        var oktadomain = "<%= oktaDomain %>";
        var oktaloginurl= "<%= idpURL %>" ;
        function redirectIDPServer(){
            var loginName = $("input[name=login]").val();

            // multi domain lists separated by Semicolon
            var multiDomainNames = oktadomain.split(';');

            if(oktadomain != "null"){
                for(var i =0 ;i < multiDomainNames.length ;i++){
                    if(loginName.indexOf(multiDomainNames[i]) !== -1){
                        var scoID= <%= scoID %>;
                        var relayState='{"action":"EVENT_REGISTRATION","scoID":'+scoID.toString()+'}';
                        window.location = makeSSOLoginUrl(oktaloginurl, relayState);
                        return false;
                    }
                }
            }
            return true;
        }

        // function to construct sso login url based on template
        function makeSSOLoginUrl(oktaLoginURL, relayState ){
                var ssoLoginUrl = "";
                if(oktaLoginURL.indexOf('{$') == -1){
                    ssoLoginUrl = makeDefaultSSOLoginUrl(oktaLoginURL, relayState);
                }        
                else
                    ssoLoginUrl = oktaLoginURL.replace("{$RELAYSTATE}", encodeURIComponent(relayState));
                return ssoLoginUrl;
        }
        
        function makeDefaultSSOLoginUrl (oktaLoginURL, relayState){
            var ssoLoginUrl = "";
            if(oktaLoginURL.indexOf('?') == -1)
                ssoLoginUrl = oktaLoginURL + "?RelayState=" + encodeURIComponent(relayState);
            else
                ssoLoginUrl = oktaLoginURL + "&RelayState=" + encodeURIComponent(relayState);
            return ssoLoginUrl;
        }
    </script>
    
</form>

</div>
