<%@include file="/apps/connect/common.jsp" %>
<%@page import="com.adobe.connect.osgi.info.*" %>

<%
    String inputLabelCSS = (String)request.getAttribute("registrationPageCSS");
    EventField eventField = (EventField)request.getAttribute("eventField");
	String value = null;
	// find value from the request
	value = slingRequest.getParameter(eventField.getInteractionId());
	if( value != null && !value.isEmpty() ){
		value = xssUtilService.getValidJSToken(value);
	} else {
		// if there is no value in the request, try to load it from the eventField object
		value = eventField.getValue() != null ? eventField.getValue() : "";
	}
%>
<div class="event_reg_label" <%= inputLabelCSS %> >
<%= ConnectUtil.escapeHtml(eventField.getDescription()) %>
<%
    if("true".equals(eventField.getIsRequired())) {
    %>
        <span class="mandatory">*</span>
<%  }
%>
</div>
<select name="<%= eventField.getInteractionId() %>"  id="<%= eventField.getInteractionId() %>" class="event_reg_field" onKeyPress="return checkSubmit(event, regFormSubmit)" onchange="this.title = this.options[this.selectedIndex].text">
	<option value=""><%= eventResBundle.getString("defaultMultipleChoiceOption") %></option>
<%
for (MultipleChoiceOption option : eventField.getChoiceOptions()) {  
%>
    <option title="<%= ConnectUtil.escapeHtml(option.getDescription()) %>" value="<%= ConnectUtil.escapeHtml(option.getDescription()) %>" <%= ConnectUtil.escapeHtml(option.getDescription()).equals(value) ? "selected" : "" %>>
    	<%= ConnectUtil.escapeHtml(option.getDescription().substring(0, option.getDescription().length() < 31 ? option.getDescription().length() : 31)) %> 
    </option>
<%
}
%>
</select>
<br/><span id="<%=eventField.getInteractionId()+"_errorMessage"%>" class="error_msg_registration"></span>

<script type="text/javascript">
<% if("true".equals(eventField.getIsRequired())) { %>
    $CQ(document).ready(function() {
        $CQ("select[name='<%=eventField.getInteractionId()%>']").change(
            function() {
                var valPassed = validateRequired(this);
                return valPassed;
            });
        });
<% } %>
</script>
