<%@include file="/apps/connect/common.jsp" %>
<%@page import="com.adobe.connect.osgi.info.*, java.text.MessageFormat" %>



<%
    String accountId = getAccountId(currentNode, request, connectInfo, connectAPIService, isIndependentCQInstance);
    String inputLabelCSS = (String)request.getAttribute("registrationPageCSS");
    EventField eventField = (EventField)request.getAttribute("eventField");
    boolean idpAuth = (Boolean)request.getAttribute("idpAuth");
    boolean isPreview = (Boolean)request.getAttribute("isPreview");    
    
    // find value from the request    
    String value = xssUtilService.encodeForHTMLAttr(slingRequest.getParameter(eventField.getInteractionId()));
    if(value == null) {
        // if there is no value in the request, try to load it from the eventField object
        value = eventField.getValue() != null ? eventField.getValue() : "";
    }
    
    // password rules
    PasswordRules passwordRules = null;
    if("password".equals(eventField.getName())) {
        passwordRules = connectAPIService.getPasswordRules( accountId  );
    }
    
%>
<div class="event_reg_label" <%= inputLabelCSS %> >
	<label for="<%=eventField.getInteractionId()%>" >
	<%= ConnectUtil.escapeHtml(eventField.getDescription()) %>
	</label>
	<%
	    String onfocusStr = "";
	    String isRequired = eventField.getIsRequired();
	    String validationType = "\'"+eventField.getInputDataType()+"\'";
	    String type = "text";	    
	    
	    if (!(eventField.getIsRequired()==null || eventField.getIsRequired().equals("")))
	    {
	        if ("password-interaction".equals(eventField.getInputDataType())) 
	        {
	            type = "password";
	            value = "";
	            onfocusStr = "onfocus=\"this.select()\"";
	        }
	        if (eventField.getIsRequired().equals("true"))
	        {
	            %><span class="mandatory">*</span><%
	        }
	    }
	        
	    boolean isDisabled = false;
	    boolean isReadonly = false;
	    if (eventField.getInteractionId().equalsIgnoreCase("first-name") || eventField.getInteractionId().equalsIgnoreCase("last-name") || eventField.getInteractionId().equalsIgnoreCase("login")) {
	    	if (idpAuth == true) {
	    		
	    		isReadonly = true;
	    		
	    	} else if ((null != xssUtilService.encodeForHTML(slingRequest.getParameter("login-ok")) || null != connectSessionId ) && !isPreview) {
		        
	    		isDisabled = true;
		    }    
	    	
	    }
	    
    %>     
</div>

<%

    String passwordHint = "";

   
%>
<input title="<%= ConnectUtil.escapeHtml(eventField.getDescription()) %>" type = "<%= type %>" name="<%=eventField.getInteractionId()%>" id="<%=eventField.getInteractionId()%>" class="event_reg_field" value="<%= ConnectUtil.escapeHtml(value) %>" <%= onfocusStr %> onKeyPress="return checkSubmit(event, regFormSubmit)" <%= isReadonly ? "readonly=\"readonly\" style=\"background: #EFEFEF;\"" : "" %> <%= isDisabled ? "disabled=\"disabled\" style=\"background: #EFEFEF;\"" : "" %> <%= isRequired.equals("true") ? "aria-required=\"true\" required=\"true\"" : "" %> />&nbsp;
<% 
    if(passwordRules != null) { %>
        <a id="password_hint" class="event_reg_pwd_rules_link" aria-hidden="true" role="presentation" href="javascript:void(0)"><%= eventResBundle.getString("labelHints") %>
                    
           <%
           String requirement = null;
           %>
              <div id="event_reg_pwd_rules" class="event_reg_pwd_rules_msg">
                <%
                passwordHint += MessageFormat.format ( eventResBundle.getString("eventRegistrationPasswordLength"), passwordRules.getMinLength(), passwordRules.getMaxLength() ) + "<br/>";
                %>
                <%= MessageFormat.format ( eventResBundle.getString("eventRegistrationPasswordLength"), passwordRules.getMinLength(), passwordRules.getMaxLength() )%>              
                <%
                    requirement = passwordRules.getSpecialChar();
                    if(requirement != null) {
                        passwordHint += MessageFormat.format ( eventResBundle.getString("eventRegistrationPasswordSpecialChar"), requirement ) + "<br/>";
                    %>
                        <br>
                        <%= MessageFormat.format ( eventResBundle.getString("eventRegistrationPasswordSpecialChar"), requirement )%>
                    <%
                    }
                    
                    requirement = passwordRules.getRequiresSpecialCharacters();
                    if("yes".equals(requirement)){
                    	passwordHint += eventResBundle.getString("eventRegistrationPasswordChar") + "<br/>";
                    %>
                        <br>
                        <%= eventResBundle.getString("eventRegistrationPasswordChar") %>                       
                    <%
                    	
                    }
                    
                    requirement = passwordRules.getRequiresCapitalLetter();
                    if("yes".equals(requirement)) {
                        passwordHint += eventResBundle.getString("eventRegistrationPasswordCapitalLetter") + "<br/>";
                    %>
                        <br>
                        <%= eventResBundle.getString("eventRegistrationPasswordCapitalLetter") %>                       
                    <%
                    }
                    
                    requirement = passwordRules.getRequiresDigit();
                    if("yes".equals(requirement)) {
                        passwordHint += eventResBundle.getString("eventRegistrationPasswordNumber")  + "<br/>";
                    %>
                        <br>
                        <%= eventResBundle.getString("eventRegistrationPasswordNumber") %>
                    <%
                    }
                %>
            </div> 
           
           		
		</a>
        <input type="hidden" name="passwordHint" value="<%=passwordHint%>" />
    <%
    }   
%>


<br/><span id="<%=eventField.getInteractionId()+"_errorMessage"%>" class="error_msg_registration"></span>

<script type="text/javascript">
$CQ(document).ready(function() {
    $CQ("input[id='<%=eventField.getInteractionId()%>']").change(
            function() {
                var valPassed = validate(this,<%=isRequired%>,<%=validationType%>);
                return valPassed;
            });
});
</script>

      
