<%@include file="/apps/connect/common.jsp" %>
<%
ResourceBundle resBundle = slingRequest.getResourceBundle(null);

String eventTime = null;

EventInfo eventInfo = getEventInfo(slingRequest, currentNode, connectAPIService);
if (eventInfo != null) {
	String beginDateStr = eventInfo.getBeginDate();
	String endDateStr   = eventInfo.getEndDate();
	String eventLang    = eventInfo.getLang();
	
	if (beginDateStr != null && beginDateStr.length() > 0 && endDateStr != null && endDateStr.length() > 0 && eventLang != null && eventLang.length() > 0) {
		Calendar beginDate = ConnectUtil.parseDate(beginDateStr);
		Calendar endDate   = ConnectUtil.parseDate(endDateStr);
		beginDate.setTimeZone(getTimeZone(request));
		endDate.setTimeZone(getTimeZone(request));
		
		// get date & time pattern
		String datePattern = null;
		if (currentNode.hasProperty("dateFormat")) {
		    datePattern = properties.get("dateFormat", "");
		}
		String timePattern = null;
		if (currentNode.hasProperty("timeFormat")) {
		    timePattern = properties.get("timeFormat", "");
		}
		
		Locale locale = ConnectUtil.getLocale(eventLang);
		eventTime = ConnectUtil.getLocalizedCalendarSpanString(beginDate, endDate, datePattern, timePattern, locale);
	}
}

if (eventTime == null) {
    eventTime = eventResBundle.getString("defaultBeginDate");
}

String style = ContentUtils.getCSSStyle(properties, isIndependentCQInstance);
%><div class="event_time" <%= style %>><%= eventTime %></div>

