<%--
  Copyright 1997-2008 Day Management AG
  Barfuesserplatz 6, 4001 Basel, Switzerland
  All Rights Reserved.

  This software is the confidential and proprietary information of
  Day Management AG, ("Confidential Information"). You shall not
  disclose such Confidential Information and shall use it only in
  accordance with the terms of the license agreement you entered into
  with Day.

  ==============================================================================

  Default page component.

  Is used as base for all "page" components. It basically includes the "head"
  and the "body" scripts.

  ==============================================================================

--%>
<%@include file="/libs/foundation/global.jsp" %>

<%@page session="false"
   contentType="text/html; charset=utf-8" 
   import="java.util.*,
    java.net.*,
    com.day.cq.commons.Doctype,
    java.util.GregorianCalendar,
    com.day.cq.wcm.api.WCMMode,
    org.apache.commons.lang.StringEscapeUtils,
    java.util.regex.Pattern,
    java.util.regex.Matcher,
    com.adobe.connect.osgi.service.*,
    com.adobe.connect.osgi.action.*,
    com.adobe.connect.osgi.info.*,
    com.adobe.connect.osgi.common.Constants,
    java.text.MessageFormat,  
    com.adobe.connect.osgi.util.*,
    com.adobe.connect.osgi.service.exception.*,
    com.adobe.granite.xss.XSSAPI,
    com.adobe.connect.client.xmlapi.APIException,
    com.day.cq.wcm.foundation.ELEvaluator" 
%><%
%><%@taglib prefix="cq" uri="http://www.day.com/taglibs/cq/1.0" %><%
%><cq:defineObjects/>

<%!
    private static final String SAMEORIGIN = "0";
    private static final String ALLOWFROM = "1";
	private static final String ALLOWFROM_DELIMITER =" ";
%>

<%

    // read the redirect target from the 'page properties' and perform the
    // redirect if WCM is disabled.
    String location = properties.get("redirectTarget", "");
    // resolve variables in path
    location = ELEvaluator.evaluate(location, slingRequest, pageContext);
    if (WCMMode.fromRequest(request) != WCMMode.EDIT && location.length() > 0) {
        // check for recursion
        if (!location.equals(currentPage.getPath())) {
            final String redirectTo = slingRequest.getResourceResolver().map(request, location) + ".html";
            response.sendRedirect(redirectTo);
        } else {
            response.sendError(HttpServletResponse.SC_NOT_FOUND);
        }
        return;
    }
    // set doctype
    if (currentDesign != null) {
        currentDesign.getDoctype(currentStyle).toRequest(request);
    }
    
    //Since common.jsp can not be included in this jsp file
    //some of the functionality is included in it to determine event language

    
    Node connectInfo = null;
    APIProvider connectAPIService = null;
    String connectServer = null;
    String connectSessionId = null;
    try
    {
    if (currentNode!=null) {
        connectInfo =  currentNode.getSession().getNode("/content/connect/connectinfo");
    }
        ConnectService connectService = sling.getService(ConnectService.class);
        connectServer = connectService.getConnectServerUrl();
        connectSessionId = ConnectUtil.validateAndGetConnectSessionId(request, connectServer);
        connectAPIService = connectService.getAPIProvider(connectSessionId);        
        }
    catch(Exception exp)
    {
        throw new Exception("unable to initialize connect properties",exp);
    }

	boolean isIndependentCQInstance = ContentUtils.isIndependentCQInstance(slingRequest.getResourceResolver().adaptTo(Session.class));
    String accountId = ContentUtils.getConnectAccountId(currentNode, request, connectInfo, isIndependentCQInstance);
    
    if(WCMMode.fromRequest(request) != WCMMode.EDIT) {

        if(accountId != null) {
            AccountXFrameOptions accountXFrameOptions = connectAPIService.getAccountXFrameOptions(accountId);
            boolean enableXFrame = accountXFrameOptions.isEnableXFrame();
            if(enableXFrame){
			    String allowFrom = accountXFrameOptions.getAllowFrom();
                String allowFromURI = accountXFrameOptions.getAllowFromURI();
                String cqServerURI = accountXFrameOptions.getCqPublishURI();
                String accountURI = accountXFrameOptions.getAccountURI();
                
                String defaultAllowFromURI = cqServerURI.concat(ALLOWFROM_DELIMITER).concat(accountURI);
				
                List<String> xframeWhitelist;

				if (ALLOWFROM.equals(allowFrom)){
					allowFromURI = defaultAllowFromURI.concat(ALLOWFROM_DELIMITER).concat(allowFromURI);
					xframeWhitelist = Arrays.asList(allowFromURI.split("\\s+"));
					
					// Content-Security-Policy is for all browsers except for IE11
					response.addHeader("Content-Security-Policy", "frame-ancestors " + allowFromURI);
				} else {
					xframeWhitelist = Arrays.asList(defaultAllowFromURI.split("\\s+"));

					// Content-Security-Policy is for all browsers except for IE11
					response.addHeader("Content-Security-Policy", "frame-ancestors " + defaultAllowFromURI);
				}
				
				// X-FRAME-OPTIONS is for IE11
				String fromOrigin = request.getParameter("from-origin");
				if(fromOrigin != null){
					if(xframeWhitelist.contains(fromOrigin))
						response.addHeader("X-FRAME-OPTIONS", "ALLOW-FROM " + fromOrigin);
				}
            }
        }
     }


	// hsts header set Bug Number # CONN-4108071
	if(accountId != null){
        if(ConnectUtil.getHSTSHeaderInformation(connectServer, connectSessionId, accountId)){
            response.setHeader("Strict-Transport-Security", "max-age=31536000; includeSubDomains");
        }
    }



     Locale pageLocale = currentPage.getLanguage(false);
     boolean isError=false;
     //pageLocale.toString()
     String pageLang = ""; 
        //Set language to default in case of any error 
        XSSUtilService xssUtilService = sling.getService(com.adobe.connect.osgi.util.XSSUtilService.class);
        String REQUEST_ATTRIB_EVENT_INFO = "event-info";
        String eventId = xssUtilService.getValidLongAsString(request.getParameter("sco-id"));
        if ( null == eventId || 0 == eventId.length() ) {
            eventId = (String)request.getAttribute("sco-id");
            if ( null == eventId || 0 == eventId.length() ) {         
                Node parentContainerComponent = ContentUtils.getParentOfType(currentNode, Constants.EVENT_ASSOCIATER_COMPONENT_PATH, "cq:Page");
                if ( null == parentContainerComponent ) {
                    parentContainerComponent = ContentUtils.getParentOfType(currentNode, Constants.EVENT_ASSOCIATER_COMPONENT_PATH, "cq:Page");
                    if ( null == parentContainerComponent ) {
                        isError = true;
                    }
                }
                try {
                    eventId = parentContainerComponent.getProperty("sco").getString();
                } catch ( Exception e ) {
                    isError = true;
                }                   
                if ( null == eventId || 0 == eventId.length() ) {
                    isError = true;
                }
            }
        }
        
        EventInfo eventInfo = null;
        if(!isError){
                String attributeName = REQUEST_ATTRIB_EVENT_INFO + "-" + eventId; 
                eventInfo = (EventInfo)request.getAttribute(attributeName);
                if (eventInfo == null){ 
                    try {
                        eventInfo = connectAPIService.getEvent(eventId);
                    } catch ( ConnectServiceException ex ) {                    
                        eventInfo = null; 
                        isError = true;
                    }
                }
        }
        
        ResourceBundle eventResBundle = null; 
        if (null != eventInfo && !isError) {
            String eventLanguage = eventInfo.getLang();
            if ( null != eventLanguage ) {
                pageLang = eventLanguage;
                eventResBundle = slingRequest.getResourceBundle(new Locale(pageLang));        
            } else {
                eventResBundle = slingRequest.getResourceBundle(null);
                pageLang = eventResBundle.getLocale().toString();
            }
        }
        else
        {
            eventResBundle = slingRequest.getResourceBundle(null);
            pageLang = eventResBundle.getLocale().toString();
        }       
        
    

%><%= Doctype.fromRequest(request).getDeclaration() %>
<html lang="<%=pageLang%>">
<cq:include script="head.jsp"/>
<cq:include script="body.jsp"/>
</html>
