<%--
/****************************************************************/
/*                                                              */
/* ADOBE CONFIDENTIAL                                           */
/* _ _ _ _ _ _ _ _ _ _ _ _ _                                    */
/*                                                              */
/* Copyright [2010-2011] Adobe Systems Incorporated             */
/* All Rights Reserved.                                         */
/*                                                              */
/* NOTICE: All information contained herein is, and remains the */
/* property of Adobe Systems Incorporated and its suppliers, if */
/* any. The intellectual and technical concepts contained       */
/* herein are proprietary to Adobe Systems Incorporated and its */
/* suppliers and may be covered by U.S. and Foreign Patents,    */
/* patents in process, and are protected by trade secret or     */
/* copyright law. Dissemination of this information or          */
/* reproduction of this material is strictly forbidden unless   */
/* prior written permission is obtained from Adobe Systems      */
/* Incorporated.                                                */
/*                                                              */
/****************************************************************/

  ==============================================================================
  List Event and Email Templates.
  ==============================================================================
--%>

<%@include file="/apps/connect/common.jsp" %>
<%@ page import="   com.day.text.Text, 
                    java.util.Comparator,
                    java.util.LinkedList,
                    com.day.cq.wcm.api.PageFilter,                    
                    com.day.cq.wcm.api.Page" %>
<cq:setContentBundle/> 
<%
String accountId  = getAccountId(currentNode, request, connectInfo, connectAPIService, isIndependentCQInstance);
String principalId = (String)request.getAttribute("principal-id");
String accountHome = connectInfo.getProperty("sites").getString() + "/c1/" + accountId + "/en/events/";
Boolean hasAccess = hasWriteAccess(currentNode, currentNode.getSession());
request.setAttribute("IsTemplateList", true);
String user = ConnectUtil.escapeHtml( xssUtilService.getValidJSToken(request.getParameter("user")));
String currPagePath = currentPage.getPath();
boolean isPrivateTemplate = false;
boolean isUsersList = false;
String listTitle = "titleUserTemplates";
if ( currPagePath.equals(accountHome + "email/private") || currPagePath.equals(accountHome + "event/private")) {
    listTitle = "titleUserTemplates";
    isUsersList = true;
} else if ( currPagePath.startsWith(accountHome + "email/private/" + principalId) ) {
    listTitle = "titleMyEmailTemplates";
    isPrivateTemplate = true;
    user = null;
} else if ( currPagePath.startsWith(accountHome + "event/private/" + principalId) ) {
    listTitle = "titleMyEventTemplates";
    isPrivateTemplate = true;
    user = null;
} else if ( currPagePath.startsWith(accountHome + "email/shared") ) {
    listTitle = "titleSharedEmailTemplates";
} else if ( currPagePath.startsWith(accountHome + "event/shared") ) {
    listTitle = "titleSharedEventTemplates";
}
%>
<div class="connect-main-top-header">
    <%-- Template page header elements go there --%>
    <div><%= eventResBundle.getString(listTitle) %><%= (user != null) ? (" > " + user) : ""  %></div>
    <% if ( ! isUsersList && user == null ) { %>
        <div class="template-action-create">
            <a id="createNewTplBtn" class="roundCornerButtonLink" href="javascript:">
                <span class="leftBtnImg">&nbsp;</span>
                <span class="centerBtnImg">
                    <div style="vertical-align: middle; padding-top: 4px;"><%= eventResBundle.getString("titleCreateNewTemplate") %></div>
                </span>
                <span class="rightBtnImg">&nbsp;</span>
            </a>
            <div style="clear: both;">&nbsp;</div>
        </div>
    <% } %>
</div>


<div class="main_template_page">
    <%  
    if (principalId == null && isPrivateTemplate) {
        //if not loged in and "My Template" menu item is clicked
        %>
        <div class="template-message">
           <%= eventResBundle.getString("templateListNoLogin") %>
        </div>
        <% 
    } else {
        Iterator<Page> children = currentPage.listChildren(); 
        if(!children.hasNext()){
            //display "No templates" message
        %>
            <div class="template-message">
               <%= eventResBundle.getString("templateListNoTemplates") %>
            </div>
        <%  
        } else {
            List<Page> childList = new LinkedList<Page>();
            while (children.hasNext()) {
                childList.add(children.next());
            }
            final ResourceBundle tempEventResBundle = eventResBundle;
            Collections.sort(childList, new Comparator<Page>() {
                public int compare(Page p1, Page p2) {
                    String p1Title = tempEventResBundle.getString(p1.getTitle());
                    String p2Title = tempEventResBundle.getString(p2.getTitle());
                    return (p1Title.compareTo(p2Title));
        }
            });
            for (Page child : childList) {
            String templatePath = child.getPath();
            boolean isEventTemplate = templatePath.indexOf("/event/") > 0;
                boolean isDefaultTemplate = true;
                try {
                    currentNode.getSession().getNode(templatePath + "/jcr:content").getProperty("templateId");                  
                    isDefaultTemplate = false;
                } catch(RepositoryException ex){                    
                }
             
            if (! isUsersList && isEventTemplate) {
                templatePath = templatePath + "/" + ContentUtils.EVENT_LANDING_NODE +".html";
            } else {
                templatePath = templatePath + ".html";
            }
        %>       
            <div class="template-item">
                <% if ( ! isUsersList ) { %>
                    <div class="template-item-links"><%=ConnectUtil.escapeHtml(eventResBundle.getString(child.getTitle())) %></div>
                    <div class="template-item-path"><%= templatePath %></div>                
                    <div class="template-item-actions">
                        <% if ( hasAccess ) { %>
                            <a id="<%= child.getName() %>EditBtn" href="javascript:" title="<%= eventResBundle.getString("titleEditTemplate") %>"><img border="0" style="vertical-align: middle; padding-top: 0px;" src="/etc/designs/connect/images/editButton.png" /></a>
                            <span style="float:left">&nbsp;&nbsp;</span>
                        <% } %>
                        <a id="<%= child.getName() %>CopyBtn" href="javascript:" title="<%= eventResBundle.getString("titleCreateTemplateCopy") %>"><img border="0" style="vertical-align: middle; padding-top: 0px;" src="/etc/designs/connect/images/copyButton.png" /></a>
                        <span style="float:left">&nbsp;&nbsp;</span>
                        <% if ( hasAccess && ! isDefaultTemplate ) { %>
                            <a id="<%= child.getName() %>DeleteBtn" href="javascript:" title="<%= eventResBundle.getString("titleDeleteTemplate") %>"><img border="0" style="vertical-align: middle; padding-top: 0px;" src="/etc/designs/connect/images/deleteButton.png" /></a>
                        <% } %>
                            <span style="float:left">&nbsp;&nbsp;</span>
                        <% if ( hasAccess && ! isDefaultTemplate ) { %>
                            <a id="<%= child.getName() %>RenameBtn" href="javascript:" title="<%= eventResBundle.getString("titleRenameTemplate") %>"><img border="0" style="vertical-align: middle; padding-top: 0px;" src="/etc/designs/connect/images/renameButton.png" /></a>
                        <% } %>
                        <div style="clear: both;">&nbsp;</div>
                    </div>
                <% } else { %>
                    <div onmouseover="this.style.cursor='pointer';" onmouseout="this.style.cursor='default';" class="template-item-links-users" id="<%= child.getName() %>ListBtn">
                        <%=ConnectUtil.escapeHtml(eventResBundle.getString(child.getTitle())) %>
                    </div>
                    <div class="template-item-path"><%= templatePath %></div>
                <% } %>
            </div>
            
        <% 
       }//end while
    }
    }
    %>     
</div>
<script type="text/javascript">
    $CQ(document).ready(function() {
        initTemplateListing();
    });
</script>
