<%@include file="/apps/connect/common.jsp" %>
<%
String align = properties.get("align", "right");

StringBuilder styleDiv = new StringBuilder(); // time zone div style
styleDiv.append("text-align: ");
styleDiv.append(align);
styleDiv.append(';');

String id = currentNode.getName();
%>
<div id="<%=id%>" class="time-zone" style="<%=styleDiv.toString()%>"><%

    LinkedList<String> timeZones = ConnectUtil.getValidIcal4jTimeZones();
    TimeZone selectedTimeZone = getTimeZone(request); // get active time zone
    
    String displayedText = eventResBundle.getString("labelTimeZone") + " (<b>" + selectedTimeZone.getID().replace('_', ' ') + "</b>)";
    
    %>
    <img src="/etc/designs/connect/images/timezoneicon.png"  alt="timezone icon" style="width: 0px; height: 0px; visibility: hidden;"/><%-- WebKit fix --%>
    <select id="<%=id%>Combo" name="timeZone" aria-labelledby="<%=id%>Selected">
    <%

    long today = new java.util.Date().getTime();
    
    for (String tzId : timeZones) {
        TimeZone tz = TimeZone.getTimeZone(tzId);
        
        int offset = tz.getRawOffset() / 60000; // total offset in minutes = (time zone raw UTC offset) / 60000
        
        char sign = (offset < 0) ? '-' : '+';
        
        offset = Math.abs(offset);
        int h = offset / 60; // hours
        int m = offset % 60; // minutes
     
        String selected;
        if (tzId.equals(selectedTimeZone.getID()))
            selected = " selected='selected'";
        else
            selected = "";
        
        // Output text formated as:    <option value='Europe/Belgrade'>(UTC+01:00) Europe/Belgrade</option>
        // or, if option is selected:  <option value='Europe/Belgrade' selected='selected'>(UTC+01:00) Europe/Belgrade</option>
        out.write(String.format("<option value='%1$s'%2$s>(UTC%3$c%4$02d:%5$02d) %6$s</option>",
                tzId, selected, sign, h, m, tzId.replace('_', ' ')));
    }
    %>
    </select>
    <span id="<%=id%>Selected" class="span1"><span class="span2"><%=displayedText%></span></span>
</div>

<script type="text/javascript">
    $CQ(document).ready(function() {
        initTimeZoneComponent("<%=id%>", "<%=align%>");
    });
</script>   