// Copyright 2021 Autodesk, Inc.  All rights reserved.
//
// Use of this software is subject to the terms of the Autodesk license
// agreement provided at the time of installation or download, or which
// otherwise accompanies this software in either electronic or hard copy form.

/**
 * \file
 * Multi-platform API for the creation and management of CPU threads
 */

#pragma once
#include "ai_api.h"

/** \defgroup ai_threads Thread Management API
 * 
 * Implementation of platform-agnostic CPU threads.
 * 
 * \{
 */

AI_API void* AiThreadCreate(unsigned int (*fn)(void*), void* data, int priority);
AI_API void  AiThreadClose(void* thread);
AI_API void  AiThreadWait(void* thread);
AI_API AI_CONST void* AiThreadSelf();

#define AI_MAX_THREADS 1024  /**< maximum number of threads */

/** \name Thread Priorities
 * \{
 */
#define AI_PRIORITY_LOWEST   0x00  /**< even lower priority than \c AI_PRIORITY_LOW */
#define AI_PRIORITY_LOW      0x01  /**< low thread priority */
#define AI_PRIORITY_NORMAL   0x02  /**< normal thread priority */
#define AI_PRIORITY_HIGH     0x03  /**< high thread priority */
/*\}*/

/*\}*/
