# Copyright 2020 Autodesk, Inc.  All rights reserved.
#
# Use of this software is subject to the terms of the Autodesk license
# agreement provided at the time of installation or download, or which
# otherwise accompanies this software in either electronic or hard copy form.

from ctypes import *
from .arnold_common import ai

# Numerical Constants
#
AI_PI =               3.1415926535897931   ## pi
AI_PITIMES2 =         6.2831853071795862   ## 2 * pi
AI_PIOVER2 =          1.5707963267948966   ## pi / 2
AI_ONEOVERPI =        0.3183098861837906   ## 1 / pi
AI_ONEOVER2PI =       0.1591549430918953   ## 1 / 2pi
AI_E =                2.7182818284590452   ## e
AI_LOG2E =            1.4426950408889634   ## log_2(e)
AI_SQRT2 =            1.4142135623730951   ## sqrt(2)
AI_SQRT3 =            1.7320508075688772   ## sqrt(3)
AI_GOLDEN =           1.6180339887498948   ## Golden ratio
AI_DTOR =             0.0174532925199433   ## Degrees to radians
AI_RTOD =             57.295779513082323   ## Radians to degrees

AI_EPSILON =          1.0e-4               ## System epsilon value
AI_BIG =              1.0e12               ## Big number
AI_INFINITE =         1.0e30               ## Our convention for an "infinite" number
