/*
 * Decompiled with CFR 0.152.
 */
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class BoolPanel
extends JPanel
implements ActionListener {
    private JLabel description;
    private JRadioButton ch_yes;
    private JRadioButton ch_no;
    private String name;
    private ParamPanel param_pnl;
    private int value;
    private ItemListener boolItemListener;
    private static final long serialVersionUID = 7526472295622776147L;

    public BoolPanel(ConfigRow configRow, int n, int n2, boolean bl, ParamPanel paramPanel) {
        this.boolItemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (BoolPanel.this.ch_yes.isSelected()) {
                    BoolPanel.this.value = 1;
                } else if (BoolPanel.this.ch_no.isSelected()) {
                    BoolPanel.this.value = 0;
                }
            }
        };
        this.ch_yes = new JRadioButton("yes");
        this.ch_no = new JRadioButton("no");
        this.ch_yes.addItemListener(this.boolItemListener);
        this.ch_no.addItemListener(this.boolItemListener);
        if (this.value == 0) {
            this.ch_yes.setSelected(false);
            this.ch_no.setSelected(true);
        } else {
            this.ch_yes.setSelected(true);
            this.ch_no.setSelected(false);
        }
        this.description = new JLabel("  " + configRow.getLanguageText());
        DataObj dataObj = new DataObj(this.description, configRow.getName(), this.ch_yes, this.ch_no, configRow.isRequired());
        dataObj.setConfigRowRef(n);
        DataObj.config_data.add(dataObj);
        this.create(dataObj, n, n2, bl, paramPanel);
    }

    public BoolPanel(DataObj dataObj, int n, int n2, boolean bl, ParamPanel paramPanel) {
        this.create(dataObj, n, n2, bl, paramPanel);
    }

    private void create(DataObj dataObj, int n, int n2, boolean bl, ParamPanel paramPanel) {
        this.value = n2;
        this.param_pnl = paramPanel;
        this.name = dataObj.getName();
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        this.setBorder(BorderFactory.createEtchedBorder(1));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 2, 0, 0));
        jPanel.add(this.description);
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(gridBagLayout2);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.ch_yes);
        buttonGroup.add(this.ch_no);
        gridBagLayout2.setConstraints(this.ch_yes, this.setAllConstraints(0, 0, 1, 1, 0.0, 0.0));
        jPanel2.add(this.ch_yes);
        gridBagLayout2.setConstraints(this.ch_no, this.setAllConstraints(1, 0, 1, 1, 0.0, 0.0));
        jPanel2.add(this.ch_no);
        JLabel jLabel = new JLabel(" ");
        gridBagLayout2.setConstraints(jLabel, this.setAllConstraints(2, 0, 1, 1, 1.0, 0.0));
        jPanel2.add(jLabel);
        jPanel.add(jPanel2);
        gridBagLayout.setConstraints(jPanel, this.setAllConstraints(0, 0, 2, 1, 1.0, 0.0));
        this.add(jPanel);
        URL uRL = BoolPanel.class.getResource("images/pnl_delete.png");
        JButton jButton = new JButton(new ImageIcon(uRL));
        jButton.setEnabled(bl);
        jButton.setActionCommand("paradel");
        jButton.addActionListener(this);
        gridBagLayout.setConstraints(jButton, this.setAllConstraints(2, 0, 1, 1, 0.0, 0.0));
        this.add(jButton);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("paradel")) {
            this.param_pnl.removeParameter(this.name);
        }
    }

    private GridBagConstraints setAllConstraints(int n, int n2, int n3, int n4, double d, double d2) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = d;
        gridBagConstraints.weighty = d2;
        return gridBagConstraints;
    }
}

