/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;

public class NetworkThread
extends Thread {
    private InetAddress sendtoAddr;
    private ParamPacket param_pkt;
    private boolean broadcast;
    private static boolean debug;
    private int send_ret;
    private String error_string;
    private String param_string;
    private static final int configPort = 64000;
    private static final int RESEND_MS = 2000;
    private static final int MAX_UDP_SIZE = 2000;

    public NetworkThread() {
        debug = false;
    }

    public NetworkThread(boolean bl) {
        debug = bl;
    }

    public NetworkThread(Runnable runnable) {
        super(runnable);
    }

    public NetworkThread(String string) {
        super(string);
    }

    public NetworkThread(ThreadGroup threadGroup, Runnable runnable) {
        super(threadGroup, runnable);
    }

    public NetworkThread(Runnable runnable, String string) {
        super(runnable, string);
    }

    public NetworkThread(ThreadGroup threadGroup, String string) {
        super(threadGroup, string);
    }

    public NetworkThread(ThreadGroup threadGroup, Runnable runnable, String string) {
        super(threadGroup, runnable, string);
    }

    public NetworkThread(ThreadGroup threadGroup, Runnable runnable, String string, long l) {
        super(threadGroup, runnable, string, l);
    }

    public boolean setSendParam(InetAddress inetAddress, ParamPacket paramPacket, boolean bl) {
        this.sendtoAddr = inetAddress;
        this.param_pkt = paramPacket;
        this.broadcast = bl;
        this.error_string = new String("not send");
        this.param_string = new String("");
        this.send_ret = 1;
        return true;
    }

    @Override
    public void run() {
        block23: {
            int n = 3;
            boolean bl = true;
            try {
                DatagramSocket datagramSocket = new DatagramSocket(64000);
                byte[] byArray = this.param_pkt.getBytes();
                DatagramPacket datagramPacket = new DatagramPacket(byArray, this.param_pkt.length(), datagramSocket.getLocalSocketAddress());
                datagramPacket.setAddress(this.sendtoAddr);
                datagramSocket.setBroadcast(this.broadcast);
                while (n > 0) {
                    try {
                        datagramSocket.send(datagramPacket);
                        try {
                            datagramSocket.setSoTimeout(2000);
                            DatagramPacket datagramPacket2 = new DatagramPacket(new byte[2000], 2000, datagramSocket.getLocalSocketAddress());
                            while (bl) {
                                datagramSocket.receive(datagramPacket2);
                                byte[] byArray2 = datagramPacket2.getData();
                                if ((byArray2[8] & 0x10) > 0) {
                                    CRCSum cRCSum = new CRCSum(byArray2, datagramPacket2.getLength());
                                    if (cRCSum.checkCRC()) {
                                        if (byArray[2] == byArray2[2] && byArray[3] == byArray2[3] && byArray[4] == byArray2[4] && byArray[5] == byArray2[5] && byArray[6] == byArray2[6] && byArray[7] == byArray2[7]) {
                                            if (byArray[0] == byArray2[0] && byArray[1] == byArray2[1]) {
                                                if (byArray[8] == 1) {
                                                    this.error_string = "send ok";
                                                } else if (byArray[8] == 2) {
                                                    this.error_string = "list ok";
                                                    this.param_string = new String(byArray2, 9, datagramPacket2.getLength() - 13);
                                                } else {
                                                    this.error_string = "send failed - false ident returned";
                                                    this.send_ret = 3;
                                                }
                                            } else {
                                                this.error_string = "send failed - false mac address returned";
                                                this.send_ret = 3;
                                            }
                                        } else {
                                            this.error_string = "??? ok";
                                        }
                                        if (debug) {
                                            System.out.println(this.error_string);
                                        }
                                        this.send_ret = 0;
                                    } else {
                                        this.error_string = "send failed - false CRC";
                                        if (debug) {
                                            System.out.println("send failed - false CRC: " + Long.toHexString(cRCSum.getCRCLong()));
                                        }
                                        this.send_ret = 2;
                                    }
                                    bl = false;
                                    n = 0;
                                    continue;
                                }
                                this.error_string = "packet not expected!";
                                if (!debug) continue;
                                System.out.println("packet not expected!");
                            }
                        }
                        catch (SocketException socketException) {
                            if (debug) {
                                socketException.printStackTrace();
                            }
                            this.error_string = "send failed !";
                            return;
                        }
                    }
                    catch (IOException iOException) {
                        if (debug) {
                            iOException.printStackTrace();
                        }
                        this.error_string = "timer expired !";
                        --n;
                    }
                }
                datagramSocket.close();
            }
            catch (SocketException socketException) {
                if (!debug) break block23;
                socketException.printStackTrace();
            }
        }
    }

    public int getSendStatus() {
        return this.send_ret;
    }

    public String getSendStatusString() {
        return this.error_string;
    }

    public String getParamString() {
        if (debug) {
            System.out.println(this.param_string.replace('\u0000', ';'));
        }
        return this.param_string;
    }
}

