/*
 * Decompiled with CFR 0.152.
 */
import java.awt.HeadlessException;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.StringTokenizer;
import javax.swing.JComboBox;

public class ParamChoice
extends JComboBox {
    private static final String CONFIG_FILE_NAME = "config/omm_param.cfg";
    private boolean mandatory;
    private String[] ParamConfigString;

    public ParamChoice() throws HeadlessException {
        this.init();
    }

    public ParamChoice(int n) throws HeadlessException {
        this.init();
        if (this.getItemCount() > n) {
            this.setSelectedIndex(n);
        }
    }

    public ParamChoice(String string, boolean bl) throws HeadlessException {
        this.mandatory = bl;
        if (bl) {
            this.ParamConfigString = new String[this.getItemCount() + 1];
            this.ParamConfigString[this.getItemCount()] = this.readParamConfigString(string);
            super.addItem(string);
            this.setLightWeightPopupEnabled(true);
        } else {
            this.init_prestring(string);
        }
    }

    public ParamChoice(String string) throws HeadlessException {
        this.init_prestring(string);
    }

    private void init_prestring(String string) {
        this.init();
        for (int i = this.getItemCount(); i > 0; --i) {
            if (!string.equals(this.getItemAt(i - 1))) continue;
            this.setSelectedIndex(i - 1);
            return;
        }
        String[] stringArray = this.ParamConfigString;
        this.ParamConfigString = new String[this.getItemCount() + 1];
        for (int i = 0; i < this.getItemCount(); ++i) {
            this.ParamConfigString[i] = stringArray[i];
        }
        super.addItem(string);
        this.ParamConfigString[this.getItemCount() - 1] = new String("OPTION_STRING");
        this.setSelectedIndex(this.getItemCount() - 1);
    }

    private void init() {
        LineNumberReader lineNumberReader;
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(CONFIG_FILE_NAME);
            lineNumberReader = new LineNumberReader(fileReader);
        }
        catch (FileNotFoundException fileNotFoundException) {
            InputStream inputStream = this.getClass().getResourceAsStream(CONFIG_FILE_NAME);
            lineNumberReader = new LineNumberReader(new InputStreamReader(inputStream));
        }
        try {
            while (lineNumberReader.ready()) {
                String string;
                String[] stringArray = this.ParamConfigString;
                this.ParamConfigString = new String[this.getItemCount() + 1];
                for (int i = 0; i < this.getItemCount(); ++i) {
                    this.ParamConfigString[i] = stringArray[i];
                }
                StringTokenizer stringTokenizer = new StringTokenizer(lineNumberReader.readLine(), ",");
                if (!stringTokenizer.hasMoreTokens()) continue;
                StringTokenizer stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken(), "\"");
                stringTokenizer2.nextToken();
                if (!stringTokenizer2.hasMoreTokens()) continue;
                String string2 = stringTokenizer2.nextToken();
                super.addItem(string2);
                if (!stringTokenizer.hasMoreTokens()) continue;
                this.ParamConfigString[this.getItemCount() - 1] = string = stringTokenizer.nextToken();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private String readParamConfigString(String string) {
        FileReader fileReader = null;
        try {
            LineNumberReader lineNumberReader;
            try {
                fileReader = new FileReader(CONFIG_FILE_NAME);
                lineNumberReader = new LineNumberReader(fileReader);
            }
            catch (FileNotFoundException fileNotFoundException) {
                InputStream inputStream = this.getClass().getResourceAsStream(CONFIG_FILE_NAME);
                lineNumberReader = new LineNumberReader(new InputStreamReader(inputStream));
            }
            while (lineNumberReader.ready()) {
                StringTokenizer stringTokenizer = new StringTokenizer(lineNumberReader.readLine(), ",");
                if (!stringTokenizer.hasMoreTokens()) continue;
                StringTokenizer stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken(), "\"");
                stringTokenizer2.nextToken();
                if (!string.matches(stringTokenizer2.nextToken()) || !stringTokenizer.hasMoreTokens()) continue;
                return stringTokenizer.nextToken();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return "NO_OPTION";
    }

    public String getParamConfigString() {
        return this.ParamConfigString[this.getSelectedIndex()];
    }
}

