/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class ParamPanel
extends JPanel {
    private JPanel para_pnl;
    private JScrollPane conf_pnl;
    private JFrame main_frame;
    private GridBagLayout gbl;
    private int paramCount;
    private Vector namesOfParams;
    private static final long serialVersionUID = 7526472295622776147L;

    public ParamPanel(JFrame jFrame) {
        this.setLayout(new BorderLayout());
        this.setBorder(new BevelBorder(0));
        this.namesOfParams = new Vector();
        this.main_frame = jFrame;
        this.initParameterPanel();
    }

    public void initParameterPanel() {
        Object object;
        this.gbl = new GridBagLayout();
        this.para_pnl = new JPanel();
        this.para_pnl.setLayout(this.gbl);
        int n = ConfigReader.allParameters.size();
        this.paramCount = 0;
        for (int i = 0; i < n; ++i) {
            JPanel jPanel;
            object = (ConfigRow)ConfigReader.allParameters.elementAt(i);
            if (!((ConfigRow)object).isRequired()) continue;
            if (((ConfigRow)object).getType() == 1) {
                jPanel = new BoolPanel((ConfigRow)object, i, 0, false, this);
                this.gbl.setConstraints(jPanel, this.setAllConstraints(0, this.paramCount, 1, 1, 1.0, 1.0));
                this.namesOfParams.add(this.paramCount, ((ConfigRow)object).getName());
                this.para_pnl.add(jPanel);
            } else if (((ConfigRow)object).isList()) {
                jPanel = new ListPanel(this.main_frame, (ConfigRow)object, i, new Vector(), false, this);
                this.gbl.setConstraints(jPanel, this.setAllConstraints(0, this.paramCount, 1, 1, 1.0, 1.0));
                this.namesOfParams.add(this.paramCount, ((ConfigRow)object).getName());
                this.para_pnl.add(jPanel);
            } else {
                jPanel = new StrPanel((ConfigRow)object, i, "", false, this);
                this.gbl.setConstraints(jPanel, this.setAllConstraints(0, this.paramCount, 1, 1, 1.0, 1.0));
                this.namesOfParams.add(this.paramCount, ((ConfigRow)object).getName());
                this.para_pnl.add(jPanel);
            }
            ++this.paramCount;
        }
        this.conf_pnl = new JScrollPane();
        object = BorderFactory.createEtchedBorder(1);
        TitledBorder titledBorder = BorderFactory.createTitledBorder((Border)object, this.getCurrentLang("conf_headline"));
        this.conf_pnl.setBorder(titledBorder);
        this.conf_pnl.setViewportView(this.para_pnl);
        this.add((Component)this.conf_pnl, "Center");
    }

    public boolean addParameter(String string) {
        if (this.namesOfParams.indexOf(string) < 0) {
            int n = ConfigReader.getIndexFromConfig(string);
            if (n < 0) {
                this.updateParameterPanel(string);
            }
            this.updateParameterPanel(n);
            return true;
        }
        return false;
    }

    private String getCurrentLang(String string) {
        for (int i = 0; i < ConfigReader.allTexts.size(); ++i) {
            LanguageText languageText = (LanguageText)ConfigReader.allTexts.elementAt(i);
            if (!languageText.isSysText(string) || !languageText.isLanguage(ConfigReader.language)) continue;
            return languageText.getText();
        }
        return string;
    }

    public void setTexts() {
        Border border = BorderFactory.createEtchedBorder(1);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(border, this.getCurrentLang("conf_headline"));
        this.conf_pnl.setBorder(titledBorder);
        int n = DataObj.config_data.size();
        for (int i = 0; i < n; ++i) {
            DataObj dataObj = (DataObj)DataObj.config_data.elementAt(i);
            JLabel jLabel = dataObj.getLabel();
            jLabel.setText("  " + this.getCurrentLang(dataObj.getName()));
            if (!dataObj.isBool()) continue;
            JRadioButton jRadioButton = dataObj.getRB(true);
            jRadioButton.setText(this.getCurrentLang("bool_true"));
            jRadioButton = dataObj.getRB(false);
            jRadioButton.setText(this.getCurrentLang("bool_false"));
        }
    }

    public boolean isShown(String string) {
        return this.namesOfParams.indexOf(string) >= 0;
    }

    public void updateParameterPanel(int n) {
        ConfigRow configRow = (ConfigRow)ConfigReader.allParameters.elementAt(n);
        this.para_pnl.setLayout(this.gbl);
        if (configRow.getType() == 1) {
            BoolPanel boolPanel = new BoolPanel(configRow, n, 0, true, this);
            this.gbl.setConstraints(boolPanel, this.setAllConstraints(0, this.paramCount, 1, 1, 1.0, 1.0));
            this.namesOfParams.add(configRow.getName());
            this.para_pnl.add(boolPanel);
        } else if (configRow.isList()) {
            ListPanel listPanel = new ListPanel(this.main_frame, configRow, n, new Vector(), true, this);
            this.gbl.setConstraints(listPanel, this.setAllConstraints(0, this.paramCount, 1, 1, 1.0, 1.0));
            this.namesOfParams.add(configRow.getName());
            this.para_pnl.add(listPanel);
        } else {
            StrPanel strPanel = new StrPanel(configRow, n, "", true, this);
            this.gbl.setConstraints(strPanel, this.setAllConstraints(0, this.paramCount, 1, 1, 1.0, 1.0));
            this.namesOfParams.add(configRow.getName());
            this.para_pnl.add(strPanel);
        }
        ++this.paramCount;
        this.conf_pnl.setViewportView(this.para_pnl);
        this.add((Component)this.conf_pnl, "Center");
        this.conf_pnl.doLayout();
        this.para_pnl.doLayout();
    }

    public void updateParameterPanel(String string) {
        StrPanel strPanel = new StrPanel(string, "", true, this);
        this.gbl.setConstraints(strPanel, this.setAllConstraints(0, this.paramCount, 1, 1, 1.0, 1.0));
        this.namesOfParams.add(string);
        this.para_pnl.add(strPanel);
    }

    public void removeParameter(String string) {
        int n = this.namesOfParams.indexOf(string);
        this.namesOfParams.remove(n);
        this.para_pnl.remove(n);
        for (int i = 0; i < DataObj.config_data.size(); ++i) {
            DataObj dataObj = (DataObj)DataObj.config_data.elementAt(i);
            if (!dataObj.getName().matches(string)) continue;
            DataObj.config_data.removeElementAt(i);
        }
        this.conf_pnl.setViewportView(this.para_pnl);
        this.add((Component)this.conf_pnl, "Center");
        this.conf_pnl.doLayout();
        this.para_pnl.doLayout();
    }

    private GridBagConstraints setAllConstraints(int n, int n2, int n3, int n4, double d, double d2) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = d;
        gridBagConstraints.weighty = d2;
        return gridBagConstraints;
    }
}

