/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToolBar;

public class modeFrame
extends JFrame
implements ActionListener {
    private StationPanel station_pnl;
    private ParamPanel param_pnl;
    private Vector lang;
    private JMenu m_conf;
    private JMenu m_help;
    private JMenuItem conf_add;
    public JMenuItem conf_send;
    private JMenuItem conf_reset;
    private JMenuItem mi_exit;
    private JMenuItem help_about;
    public JButton sendconf;
    private JButton param_add;
    private JButton resetconf;
    private JComboBox languageCB;
    private static boolean debugFeature;
    public static MyStatusBar statusbar;
    private static final long serialVersionUID = 7526472295622776147L;

    public modeFrame(String string) {
        super(string);
        this.setSize(640, 550);
        this.getContentPane().setLayout(new BorderLayout());
        this.setDefaultCloseOperation(3);
        ConfigReader configReader = new ConfigReader("config/omm_param.cfg");
        configReader.readConfigFile();
        this.lang = configReader.getLanguages();
        ConfigReader.language = 1;
        JToolBar jToolBar = new JToolBar();
        this.sendconf = new JButton("Send configuration");
        this.sendconf.setEnabled(false);
        this.sendconf.setActionCommand("SEND_CONF");
        this.sendconf.addActionListener(this);
        this.param_add = new JButton("Add parameter");
        this.param_add.setActionCommand("ADD_PARAM");
        this.param_add.addActionListener(this);
        jToolBar.add(this.param_add);
        jToolBar.add(this.sendconf);
        this.resetconf = new JButton("Reset configuration");
        this.resetconf.setActionCommand("RESET_CONF");
        this.resetconf.addActionListener(this);
        jToolBar.add(this.resetconf);
        jToolBar.addSeparator();
        this.languageCB = new JComboBox(this.lang);
        this.languageCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                JComboBox jComboBox = (JComboBox)itemEvent.getSource();
                for (int i = 0; i < modeFrame.this.lang.size(); ++i) {
                    String string = (String)modeFrame.this.lang.elementAt(i);
                    if (!jComboBox.getSelectedItem().equals(string)) continue;
                    ConfigReader.language = i + 1;
                    modeFrame.this.setTexts();
                }
            }
        });
        jToolBar.add(this.languageCB);
        this.getContentPane().add((Component)jToolBar, "North");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        statusbar = new MyStatusBar();
        jPanel.add((Component)statusbar, "Center");
        this.getContentPane().add((Component)jPanel, "South");
        GridBagLayout gridBagLayout = new GridBagLayout();
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(gridBagLayout);
        this.station_pnl = new StationPanel(this);
        gridBagLayout.setConstraints(this.station_pnl, this.setAllConstraints(0, 0, 1, 1, 0.0, 0.0));
        this.param_pnl = new ParamPanel(this);
        gridBagLayout.setConstraints(this.param_pnl, this.setAllConstraints(0, 1, 1, 3, 1.0, 1.0));
        jPanel2.add(this.station_pnl);
        this.station_pnl.setParamPanel(this.param_pnl);
        jPanel2.add(this.param_pnl);
        this.getContentPane().add((Component)jPanel2, "Center");
        JMenuBar jMenuBar = new JMenuBar();
        this.m_conf = new JMenu("Configuration");
        this.conf_add = new JMenuItem("Add Parameter");
        this.conf_add.setActionCommand("ADD_PARAM");
        this.conf_add.addActionListener(this);
        this.conf_send = new JMenuItem("Send Configuration");
        this.conf_send.setActionCommand("SEND_CONF");
        this.conf_send.setEnabled(false);
        this.conf_send.addActionListener(this);
        this.conf_reset = new JMenuItem("Reset Configuration");
        this.conf_reset.setActionCommand("RESET_CONF");
        this.conf_reset.addActionListener(this);
        this.m_conf.add(this.conf_add);
        this.m_conf.addSeparator();
        this.m_conf.add(this.conf_send);
        this.m_conf.add(this.conf_reset);
        this.m_conf.addSeparator();
        this.mi_exit = new JMenuItem("Exit");
        this.mi_exit.setActionCommand("EXIT");
        this.mi_exit.addActionListener(this);
        this.m_conf.add(this.mi_exit);
        jMenuBar.add(this.m_conf);
        this.m_help = new JMenu("Help");
        this.help_about = new JMenuItem("About");
        this.help_about.setActionCommand("ABOUT");
        this.help_about.addActionListener(this);
        this.m_help.add(this.help_about);
        jMenuBar.add(this.m_help);
        this.setJMenuBar(jMenuBar);
    }

    public modeFrame(String string, boolean bl) {
        this(string);
        String string2 = this.getCurrentLang("om_configurator");
        if (!string2.equals("om_configurator")) {
            this.setTitle(string2 + new String(" ") + new VersionString());
        }
        debugFeature = bl;
    }

    public static boolean debugEnabled() {
        return debugFeature;
    }

    private GridBagConstraints setAllConstraints(int n, int n2, int n3, int n4, double d, double d2) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = d;
        gridBagConstraints.weighty = d2;
        return gridBagConstraints;
    }

    private void resetConfiguration() {
        for (int i = 0; i < DataObj.config_data.size(); ++i) {
            DataObj dataObj = (DataObj)DataObj.config_data.elementAt(i);
            ConfigRow configRow = (ConfigRow)ConfigReader.allParameters.elementAt(dataObj.getConfigRowRef());
            if (!configRow.isRequired()) {
                this.param_pnl.removeParameter(dataObj.getName());
                --i;
                continue;
            }
            if (dataObj.isText()) {
                dataObj.setText("");
                continue;
            }
            if (dataObj.isBool()) {
                dataObj.setBool(0);
                continue;
            }
            if (!dataObj.isList()) continue;
            DefaultListModel defaultListModel = (DefaultListModel)dataObj.getList().getModel();
            defaultListModel.clear();
        }
    }

    private void addParameter() {
        ParamAddDlg paramAddDlg = new ParamAddDlg(this, this.param_pnl);
        paramAddDlg.show();
    }

    private void warnMessage(String string) {
        Object[] objectArray = new Object[]{"OK"};
        String string2 = ConfigReader.getCurrentLang(string);
        String string3 = "Value of parameter '" + string2 + "' is missing!";
        JOptionPane.showOptionDialog(null, string3, "Warning", -1, 2, null, objectArray, objectArray[0]);
    }

    private String mustParameterSet() {
        String string = new String("nothing");
        for (int i = 0; i < DataObj.config_data.size(); ++i) {
            DefaultListModel defaultListModel;
            DataObj dataObj = (DataObj)DataObj.config_data.elementAt(i);
            if (!dataObj.isRequired()) continue;
            if (dataObj.isText()) {
                if (!dataObj.getText().equals("")) continue;
                string = dataObj.getName();
                continue;
            }
            if (!dataObj.isList() || !(defaultListModel = (DefaultListModel)dataObj.getList().getModel()).isEmpty()) continue;
            string = dataObj.getName();
        }
        return string;
    }

    public String getCurrentLang(String string) {
        for (int i = 0; i < ConfigReader.allTexts.size(); ++i) {
            LanguageText languageText = (LanguageText)ConfigReader.allTexts.elementAt(i);
            if (!languageText.isSysText(string) || !languageText.isLanguage(ConfigReader.language)) continue;
            return languageText.getText();
        }
        return string;
    }

    private void setTexts() {
        this.m_conf.setText(this.getCurrentLang("configuration"));
        this.m_help.setText(this.getCurrentLang("help"));
        this.conf_add.setText(this.getCurrentLang("add_param"));
        this.conf_send.setText(this.getCurrentLang("send_conf"));
        this.conf_reset.setText(this.getCurrentLang("reset_conf"));
        this.help_about.setText(this.getCurrentLang("about"));
        this.mi_exit.setText(this.getCurrentLang("exit"));
        this.sendconf.setText(this.getCurrentLang("send_conf"));
        this.param_add.setText(this.getCurrentLang("add_param"));
        this.resetconf.setText(this.getCurrentLang("reset_conf"));
        this.station_pnl.setTexts();
        this.param_pnl.setTexts();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if ("SEND_CONF".equals(actionEvent.getActionCommand())) {
            String string = this.mustParameterSet();
            if (string.equals("nothing")) {
                this.station_pnl.ParamSend();
            } else {
                this.warnMessage(string);
            }
        } else if ("RESET_CONF".equals(actionEvent.getActionCommand())) {
            this.resetConfiguration();
        } else if ("ADD_PARAM".equals(actionEvent.getActionCommand())) {
            this.addParameter();
        } else if ("ABOUT".equals(actionEvent.getActionCommand())) {
            HelpDlg helpDlg = new HelpDlg(this);
            helpDlg.show();
        } else if ("EXIT".equals(actionEvent.getActionCommand())) {
            this.hide();
            this.dispose();
            System.exit(0);
        }
    }
}

