#!/bin/bash
usage(){
	echo "$0 BACKUP_DIR"
	echo "BACKUP_DIR : Directory containing the backed up files which are to be merged."
	echo "Note : SAL Agent should be stopped before executing this script and started once execution is complete."
	exit 1
}

. /etc/profile

if [ $# -lt 1 ]
then
	echo "Error : Invalid number of arguments"
	usage
fi

if [ ! -d $1 ]
then
	echo "Directory $1 does not exist."
	usage
fi

AGENT_MGMT_XML_OLD=$1/agentManagement.xml
AGENT_MGMT_XML_NEW=$SPIRIT_HOME/config/agentManagement.xml

if [ -f $AGENT_MGMT_XML_OLD ]
then
	agentRefNum=`grep UUID $AGENT_MGMT_XML_OLD | cut -d '>' -f 2 | cut -d '<' -f1`
	if [ x$agentRefNum != "x" ]
	then
		grep UUID $AGENT_MGMT_XML_NEW >> /dev/null
	
		if [ $? = 0 ]
		then
			sed -i 's/"UUID">.*<\/entry/"UUID">'$agentRefNum'<\/entry/' $AGENT_MGMT_XML_NEW
		else
			sed -i '/<properties>/a <entry key="UUID">'$agentRefNum'</entry>' $AGENT_MGMT_XML_NEW
		fi	
	else
		echo "Agent Reference Number not found in backed up file $AGENT_MGMT_XML_OLD."
		exit 1
	fi
else
	echo "$AGENT_MGMT_XML_OLD does not exist so could not merge Agent Reference in $AGENT_MGMT_XML_NEW"
	exit 1
	
fi

DT_CONFIG_XML_OLD=$1/SPIRITAgent_1_0_DataTransportConfig_orig.xml
DT_CONFIG_XML_NEW=$SPIRIT_HOME/config/agent/SPIRITAgent_1_0_DataTransportConfig_orig.xml

if [ -f $DT_CONFIG_XML_OLD ]
then
	spiritPlatformQualifier=`grep SpiritPlatformQualifier $DT_CONFIG_XML_OLD | cut -d '>' -f 2 | cut -d '<' -f1`
	if [ x$spiritPlatformQualifier != "x" ]
	then
		grep SpiritPlatformQualifier $DT_CONFIG_XML_NEW >> /dev/null

		if [ $? = 0 ]
                then
			sed -i 's/"SpiritPlatformQualifier".*<\/entry/"SpiritPlatformQualifier">'$spiritPlatformQualifier'<\/entry/' $DT_CONFIG_XML_NEW
		else
			sed -i '/<properties>/a <entry key="SpiritPlatformQualifier">'$spiritPlatformQualifier'</entry>' $DT_CONFIG_XML_NEW
		fi
	else
		echo "Spirit Platform Qualifier not found in the backed up file $DT_CONFIG_XML_OLD."
		exit 1
	fi
else
	echo "$DT_CONFIG_XML_OLD does not exist so could not merge Spirit Platform Qualifier in $DT_CONFIG_XML_NEW."
	exit 1
fi
