#!/bin/bash

. /etc/profile

if [ $# -lt 1 ]
then
	echo "Error : Invalid number of arguments"
	exit 1
fi

SUPPORTPROD_XML_OLD=`ls $1/SPIRITAgent_1_0_supportedproducts*.xml | tail -1`

if [ "$SUPPORTPROD_XML_OLD" = "" ]
then
	echo "Error : Backup supported products file not found"
	exit 1
fi

SUPPORTPROD_XML_NEW=`ls $SPIRIT_HOME/config/agent/SPIRITAgent_1_0_supportedproducts*.xml | tail -1`

if [ ! -f $SUPPORTPROD_XML_NEW ]
then
	echo "Error : Supported products file not found"
	exit 1
fi

grep "<prodType>" $SUPPORTPROD_XML_OLD | cut -d">" -f2 | cut -d"<" -f1 > tmp.txt

for product in `cat tmp.txt`
do
	echo "Product = $product"
	Line=`grep -n "<prodType>$product</prodType>" $SUPPORTPROD_XML_OLD | cut -d":" -f1`
	LineNo=`expr $Line - 1`

	mgElemId=`sed -n "$LineNo p" $SUPPORTPROD_XML_OLD | cut -d">" -f2 | cut -d"<" -f1`	
	echo "Managed Element Id = $mgElemId"

	Line=`grep -n -B1 "<prodType>$product</prodType>" $SUPPORTPROD_XML_NEW | head -1 | cut -d"-" -f1`

	if [ "$Line" = "" ]
	then
		echo "Couldn't find product $product in $SUPPORTPROD_XML_NEW"
		continue
	fi

	sed -i ''${Line}'s/mgdElementId>.*<\/mgdElementId/mgdElementId>'$mgElemId'<\/mgdElementId/' $SUPPORTPROD_XML_NEW		

done

rm tmp.txt

BASEAGENTCONFIG_OLD=`ls $1/SPIRITAgent_1_0_BaseAgentConfig*.xml | tail -1`

if [ "$BASEAGENTCONFIG_OLD" = "" ]
then
	echo "Error : Backup BaseAgent Config file not found"
	exit 1
fi

BASEAGENTCONFIG_NEW=`ls $SPIRIT_HOME/config/agent/SPIRITAgent_1_0_BaseAgentConfig*.xml | tail -1`

if [ ! -f $BASEAGENTCONFIG_NEW ]
then
	echo "Error : $BASEAGENTCONFIG_NEW file not found"
	exit 1
fi

alarmid=`grep "SPIRIT.alarmid" $BASEAGENTCONFIG_OLD | cut -d">" -f2 | cut -d"<" -f1`
echo "Alarm id = $alarmid"
sed -i 's/"SPIRIT.alarmid">.*<\/entry/"SPIRIT.alarmid">'$alarmid'<\/entry/' $BASEAGENTCONFIG_NEW
