#!/bin/bash

usage(){
	echo "Error : Invalid number of arguments"
	echo "$0 -c [HOST_NAME] [PORT] [ENROLLMENT_PASSWORD] [PLATFORM_QUALIFIER]"
	echo "-c : Required only if certificates are to be re-configured."
	echo "HOST_NAME : Fully Qualified Host Name of System Manager"
	echo "PORT : HTTPS port of System Manager; Required only if certificates are to be re-configured"
	echo "ENROLLMENT_PASSWORD : Enrollment password (created using SMGR UI); Required only if certificates are to be re-configured"
	echo "PLATFORM_QUALIFIER : (Optional) If specified this will be used as the platform qualifier of SMGR, else"
	echo "default would be assumed (Enterprise-HOST_NAME)"
	exit 1
}

if [ $SPIRIT_HOME"x" = "x" ]
then
	echo "Environment variable SPIRIT_HOME needs to be defined and must be pointing to the SAL Agent's install location."
	exit 1
fi

CONFIGURE_CERTS="false"

while getopts c opt
do      case "$opt" in
        c)      CONFIGURE_CERTS="true"; shift ;;
        [?])    usage;;
        esac
done

if [ $CONFIGURE_CERTS = "false" ]
then
	if [ $# -lt 1 ]
	then
		usage
	fi
	smgr_hostname=$1
	if [ $2"x" = "x" ]
	then
		platform_qualifier="Enterprise-"$smgr_hostname
	else
		platform_qualifier=$2
	fi
else
	if [ $# -lt 3 ]
	then
		usage
	fi 
	smgr_hostname=$1
	smgr_port=$2
	epassword=$3

	if [ $4"x" = "x" ]
	then
		platform_qualifier="Enterprise-"$smgr_hostname
	else
		platform_qualifier=$4
	fi
fi

BASEAGENTCONFIG=`ls $SPIRIT_HOME/config/agent/SPIRITAgent_1_0_BaseAgentConfig*.xml | tail -1`
DTCONFIG=`ls $SPIRIT_HOME/config/agent/SPIRITAgent_1_0_DataTransportConfig*.xml | tail -1`
COMPCONFIG=`ls $SPIRIT_HOME/config/agent/SPIRITAgent_1_0_SpiritComponentConfig*.xml | tail -1`

result=0

if [ $CONFIGURE_CERTS = "true" ]
then
	cd $SPIRIT_HOME/TM_client/unix/

	sh EnableHostAgentSecurity_postinstall.bsh $smgr_hostname $smgr_port $epassword

	result=$?

	cd -
fi

if [ $result = 0 ]
then
smgr_mgmt_https_port=10443
sed -i 's/"SPIRIT.LoggingServiceURL">.*<\/entry/"SPIRIT.LoggingServiceURL">https\:\/\/'$smgr_hostname':'$smgr_mgmt_https_port'\/LoggingService-LoggingService\/LoggingService<\/entry/' $BASEAGENTCONFIG

sed -i 's/"Connection.AvayaBase.PlatformQualifier">.*<\/entry/"Connection.AvayaBase.PlatformQualifier">'$platform_qualifier'<\/entry/' $DTCONFIG

sed -i 's/"Connection.AvayaBase.URL.0">.*<\/entry/"Connection.AvayaBase.URL.0">https\:\/\/'$smgr_hostname':'$smgr_mgmt_https_port'\/DataTransport_Servlet\/servlet\/TransportReceiverServlet<\/entry/' $DTCONFIG

sed -i 's/"Connection.AvayaBase.URL.1">.*<\/entry/"Connection.AvayaBase.URL.1">https\:\/\/'$smgr_hostname':'$smgr_mgmt_https_port'\/DataTransport_Servlet\/servlet\/TransportReceiverServlet<\/entry/' $DTCONFIG

sed -i 's/"Address.AgentHeartbeat">.*<\/entry/"Address.AgentHeartbeat">AgentHeartbeat@avaya.com., '$platform_qualifier'<\/entry/' $COMPCONFIG

sed -i 's/"Address.Inventory">.*<\/entry/"Address.Inventory">Inventory@avaya.com., '$platform_qualifier'<\/entry/' $COMPCONFIG

sed -i 's/"Address.ConfirmConfiguration">.*<\/entry/"Address.ConfirmConfiguration">ConfirmConfiguration@avaya.com., '$platform_qualifier'<\/entry/' $COMPCONFIG

sed -i 's/"Address.SNMP">.*<\/entry/"Address.SNMP">alarms@avaya.com., '$platform_qualifier'<\/entry/' $COMPCONFIG

sed -i 's/"Address.ProcessLog">.*<\/entry/"Address.ProcessLog">ProcessLog@avaya.com., '$platform_qualifier'<\/entry/' $COMPCONFIG
else
	echo "SMGR Host Name change failed."
	exit 1
fi
