#!/bin/bash

usage(){
	echo "$0 OLD_IP_ADDRESS NEW_IP_ADDRESS"
	echo "OLD_IP_ADDRESS : Old IP address"
	echo "NEW_IP_ADDRESS : New IP address"
	exit 1
}

if [ $# -ne 2 ]
then
	echo "Invalid number of arguments."
	usage
fi

NET_SNMP_CONF=/var/net-snmp/snmpd.conf
OLD_IP_ADDRESS=$1
NEW_IP_ADDRESS=$2

OLD_IP_ADDRESS_SPLIT=`echo $OLD_IP_ADDRESS | sed 's/\./ /g'`
OLD_IP_ADDRESS_HEX=`printf "0x%02x%02x%02x%02x" $OLD_IP_ADDRESS_SPLIT`

NEW_IP_ADDRESS_SPLIT=`echo $NEW_IP_ADDRESS | sed 's/\./ /g'`
NEW_IP_ADDRESS_HEX=`printf "0x%02x%02x%02x%02x" $NEW_IP_ADDRESS_SPLIT`

OLD_IP_ADDRESS_ASCII=`echo -n $OLD_IP_ADDRESS | od --width=256 -A n -t x1 | sed 's/ //g'`

NEW_IP_ADDRESS_ASCII=`echo -n $NEW_IP_ADDRESS | od --width=256 -A n -t x1 | sed 's/ //g'`

grep "targetAddr .* .* $OLD_IP_ADDRESS_HEX.*" $NET_SNMP_CONF >> /dev/null

if [ $? = 0 ]
then
        sed -i '/snmpNotifyTable[ ]\+0x'$OLD_IP_ADDRESS_ASCII'.* 0x'$OLD_IP_ADDRESS_ASCII'.*/s/'$OLD_IP_ADDRESS_ASCII'/'$NEW_IP_ADDRESS_ASCII'/g' $NET_SNMP_CONF
        sed -i '/targetAddr .* .* '$OLD_IP_ADDRESS_HEX'.*/s/'$OLD_IP_ADDRESS_HEX'/'$NEW_IP_ADDRESS_HEX'/g' $NET_SNMP_CONF
        sed -i '/targetAddr '$OLD_IP_ADDRESS'.* .*/s/'$OLD_IP_ADDRESS'/'$NEW_IP_ADDRESS'/g' $NET_SNMP_CONF
        sed -i '/targetParams '$OLD_IP_ADDRESS'.*/s/'$OLD_IP_ADDRESS'/'$NEW_IP_ADDRESS'/g' $NET_SNMP_CONF
else
        echo "$OLD_IP_ADDRESS not found in $NET_SNMP_CONF"
fi

exit 0
