#!/bin/bash
. /etc/profile
usage(){
	echo "$0 [-l] [-r] [-i] -v PROTOCOL_VERSION [-c COMMUNITY] [-u USER_NAME] [-a AUTH_PROTOCOL] [-A AUTH_PASSWD] [-x PRIV_PROTOCOL] [-X PRIV_PASSWD] IP_ADDRESS PORT"
	echo "-l : Lists the configured NMS one on each line : 'IP_ADDRESS PORT COMMUNITY'"
	echo "-r : Remove the specified NMS location from the list of configured NMS"
	echo "-i : This option is for enabling informs"
	echo "-v PROTOCOL_VERSION : Protocol version has to be either of v2 or v3"
	echo "-c COMMUNITY : Community string for SNMPv2c NMS; if not specified, default value is 'public'"
	echo "-u USER_NAME : Username for v3 NMS; is mandatory to specify if PROTOCOL_VERSION is v3"
	echo "-a AUTH_PROTOCOL : Authentication Protocol for the v3 user; either of MD5 or SHA"
	echo "-A AUTH_PASSWD : Authentication Password for the specified Authentication Protocol"
	echo "-x PRIV_PROTOCOL : Privacy Protocol for the v3 user; any value out of AES and DES"
	echo "-X PRIV_PASSWD : Privacy Password for the specified privacy protocol"
	echo "IP_ADDRESS : IP address of the NMS; required for remove/add"
	echo "PORT : Port of the NMS on which it is listening for traps/informs; required for add"
 	exit 1
}

OPER="add"
TYPE="trap"
INFORM="false"

while getopts rlv:c:u:a:A:x:X:i opt
do      case "$opt" in
        r)      OPER="remove" ;;
	l)	OPER="list"; shift ;;
	i)	INFORM="true" ;;
	v) 	VERSION=$OPTARG;;
	c)	COMMUNITY=$OPTARG;;
	u)	USERNAME=$OPTARG;;
	a)	AUTH_PROTOCOL=$OPTARG;;
	A)	AUTH_PASSWD=$OPTARG;;
	x)	PRIV_PROTOCOL=$OPTARG;;
	X)	PRIV_PASSWD=$OPTARG;;
	[?])    usage;;
        esac
done

CLASSPATH=$SPIRIT_HOME/lib/snmp4j.jar:$SPIRIT_HOME/lib/snmp4j-agent.jar:$SPIRIT_HOME/lib/spiritAgent.jar:$SPIRIT_HOME/lib/spirit-common-api.jar:$SPIRIT_HOME/lib/avaya_logging_client.jar:$SPIRIT_HOME/lib/log4j-api.jar:$SPIRIT_HOME/lib/log4j-core.jar:$SPIRIT_HOME/lib/avaya_logging_formatter.jar
# Sample JPDA settings for remote socket debuging
#JAVA_OPTS="$JAVA_OPTS -Xrunjdwp:transport=dt_socket,address=8989,server=y,suspend=y"

if [ $# -eq 0 -a $OPER != "list"  ]
then
	usage
fi


if [ $OPER = "list" ]
then	
	java -cp $CLASSPATH com.avaya.spirit.agent.tools.cli.ConfigureNMSLocations "list" 
	exit $?
fi

if [ $OPER = "remove" ]
then
        if [ $# -lt 1 ]
        then
                usage
	fi

	if [ $INFORM = "true" ]
        then
		java -cp $CLASSPATH com.avaya.spirit.agent.tools.cli.ConfigureNMSLocations "remove" $VERSION ${5} ${6} "inform"
		exit $?
	else
		java -cp $CLASSPATH com.avaya.spirit.agent.tools.cli.ConfigureNMSLocations "remove" $VERSION ${4} ${5}
		exit $?
	fi
fi


if [ $OPER = "add" -a $VERSION = "v2" ]
then
	if [ $INFORM = "true" ]
 	then
		if [ $# -eq 7 ]
		then
			java -cp $CLASSPATH com.avaya.spirit.agent.tools.cli.ConfigureNMSLocations $VERSION $COMMUNITY ${6} ${7} "inform"
			exit $?
		else
			usage
		fi
	else
		if [ $# -eq 6 ]
		then
			java -cp $CLASSPATH com.avaya.spirit.agent.tools.cli.ConfigureNMSLocations $VERSION $COMMUNITY ${5} ${6}
			exit $?
		else
			usage
		fi
	fi
fi

if [ $OPER = "add" -a $VERSION = "v3" ]
then
        if [ $INFORM = "true" ]
        then
                if [ $# -eq 15 ]
                then
			java -cp $CLASSPATH com.avaya.spirit.agent.tools.cli.ConfigureNMSLocations $VERSION $USERNAME $AUTH_PROTOCOL $AUTH_PASSWD $PRIV_PROTOCOL $PRIV_PASSWD ${14} ${15} "inform"
			exit $?
                else
                        usage
                fi
        else
                if [ $# -eq 14 ]
                then
			java -cp $CLASSPATH com.avaya.spirit.agent.tools.cli.ConfigureNMSLocations $VERSION $USERNAME $AUTH_PROTOCOL $AUTH_PASSWD $PRIV_PROTOCOL $PRIV_PASSWD ${13} ${14}
			exit $?
		else
			usage
                fi
        fi
fi
