#!/bin/bash

# Make sure only root can run our script
if [ "$(id -u)" != "0" ]; then
   echo "This script must be run as root" 1>&2
   exit 1
fi

usage(){
	echo "$0 [-l] [-r] [-t LOG_TAG] [-o OVERRIDE_MEID] PRODUCT_TYPE ID VERSION PATCH IPADDR [LOG_PRODUCT_TYPE]"
	echo "-l : Lists the configured supported products one on each line : 'ID PRODUCT_TYPE VERSION PATCH LOG_PRODUCT_TYPE IPADDR HOSTNAME'"
	echo "-r : Remove the specified product from the supported products list"
	echo "-t LOG_TAG : Log Tag in the syslog log entries; required for add if using syslog logs for log-alarming"
	echo "-o OVERRIDE_MEID : Product ID to be overriden for this entry; required for add if overriding product ID for log-alarming"
	echo "PRODUCT_TYPE : Product Type; required for remove/add"
	echo "ID : Product ID; required for add"
	echo "VERSION : Product Version; required for add"
	echo "PATCH : Product Patch; required for add"
	echo "IPADDR : IP Address to be used for this product; required for add"
	echo "LOG_PRODUCT_TYPE : Product type in the Avaya CLF log entries; required for add if using Avaya CLF for log-alarming"
	exit 1
}

OPER="add"
shiftnum=0
while getopts rlt:o: opt
do      case "$opt" in
        r)      OPER="remove"; shiftnum=`expr $shiftnum + 1`;;
		l)		OPER="list"; shiftnum=`expr $shiftnum + 1`;;
		t)		LOG_TAG="<logTag>$OPTARG<\/logTag>"; shiftnum=`expr $shiftnum + 2`;;
		o)		OVERRIDE_MEID="<overrideMeId>$OPTARG<\/overrideMeId>"; shiftnum=`expr $shiftnum + 2`;;
        [?])    usage;;
        esac
done

shift $shiftnum

SUPPPRODUCTS=$SPIRIT_HOME/config/agent/SPIRITAgent_1_0_supportedproducts_orig.xml

if [ $OPER = "list" ]
then
	cat $SUPPPRODUCTS | tr '<' '>' | awk -f $SPIRIT_HOME/scripts/printProducts.awk
	exit 0
fi

if [ $OPER = "add" ]
then
	if [ $# -lt 5 ]
	then
		usage
	fi

	prodType=$1
	productId=$2
	prodVersion=$3
	prodPatch=$4
	ipAddr=$5
	logProdType=$6
	hostname=`hostname`	

	grep "<prodType>$prodType</prodType>" $SUPPPRODUCTS >> /dev/null

	if [ $? = 0 ]
	then
		echo "Entry for product $prodType already exists"
		exit 1
	fi

	grep "<mgdElementId>$productId</mgdElementId>" $SUPPPRODUCTS >> /dev/null

	if [ $? = 0 ]
	then
		echo "Entry for product id $productId already exists"
		exit 1
	fi


	sed -i 's/<\/supportedProducts>/	<product>\
		<mgdElementId>'$productId'<\/mgdElementId>\
		<prodType>'$prodType'<\/prodType>\
		<prodVersion>'$prodVersion'<\/prodVersion>\
		<prodPatch>'$prodPatch'<\/prodPatch>\
		<logProductType>'$logProdType'<\/logProductType>\
		<ipAddr>'$ipAddr'<\/ipAddr>\
		<hostName>'$hostname'<\/hostName>\
		'$LOG_TAG'\
		'$OVERRIDE_MEID'\
	<\/product>\
<\/supportedProducts>\
/' $SUPPPRODUCTS
	sed -i 's/<\/p\:supportedProducts>/	<product>\
		<mgdElementId>'$productId'<\/mgdElementId>\
		<prodType>'$prodType'<\/prodType>\
		<prodVersion>'$prodVersion'<\/prodVersion>\
		<prodPatch>'$prodPatch'<\/prodPatch>\
		<logProductType>'$logProdType'<\/logProductType>\
		<ipAddr>'$ipAddr'<\/ipAddr>\
		<hostName>'$hostname'<\/hostName>\
		'$LOG_TAG'\
		'$OVERRIDE_MEID'\
	<\/product>\
<\/p\:supportedProducts>\
/' $SUPPPRODUCTS

	echo "Entry for product $prodType added successfully"
else
	if [ $# -lt 1 ]
	then
		usage
	fi

	prodType=$1

	productMatchLineNum=`grep -n -m 1 "<prodType>$prodType</prodType>" $SUPPPRODUCTS | cut -f1 -d:`

	productTagLineNums=`grep -n -B 20 -A 20 "<prodType>$prodType</prodType>" $SUPPPRODUCTS | grep "<product>" | cut -f1 -d- | sort -n -r`

	endProductTagLineNums=`grep -n -B 20 -A 20 "<prodType>$prodType</prodType>" $SUPPPRODUCTS | grep "</product>" | cut -f1 -d- | sort -n`

	if [ x$productMatchLineNum != "x" ]
	then
		for i in $productTagLineNums
		do
			if [ $i -lt $productMatchLineNum ]
			then
				startProductLineNum=$i
				break
			fi
		done

		for i in $endProductTagLineNums
		do
			if [ $i -gt $productMatchLineNum ]
			then
				endProductLineNum=$i
                                break
			fi
		done
	fi

	if [ x$startProductLineNum != "x" -a x$endProductLineNum != "x" ]
	then	
		if [ $startProductLineNum -lt $endProductLineNum ]
		then
			sed -i ''$startProductLineNum','$endProductLineNum' d' $SUPPPRODUCTS
			echo "Entry for product $prodType removed successfully"
		fi
	else
		echo "Product $prodType not found."
	fi

fi
