#!/bin/bash

# Make sure only root can run our script
if [ "$(id -u)" != "0" ]; then
   echo "This script must be run as root" 1>&2
   exit 1
fi

usage(){
	echo "Error : Invalid number of arguments"
	echo "$0 -n -c -s STORE_FORMAT HOST_NAME PORT ENROLLMENT_PASSWORD PLATFORM_QUALIFIER"
	echo "-n : (Optional) Indicates that alarming support is not required."
	echo "-c : (Optional) Indicates that certificates should not be generated"
	echo "-s KEYSTORE_FORMAT : (Optional) The format (JKS/BCFKS) of the keystore used to store the certificates. Default : JKS."
	echo "HOST_NAME : Host name of System Manager"
	echo "PORT : HTTPS port of System Manager"
	echo "ENROLLMENT_PASSWORD : Enrollment password to be used for generating trust certificate"
	echo "PLATFORM_QUALIFIER : (Optional) If specfified this will be used as the platform qualifier of SMGR, else"
	echo "default would be assumed (Enterprise-HOST_NAME)"
	exit 1
}

ALARMING_CONFIG="true"
STORE_FORMAT="JKS"
GENERATE_CERTS="true"
while getopts ncs: opt
do      case "$opt" in
        n)      ALARMING_CONFIG="false";;	
        c)      GENERATE_CERTS="false";;
        s)      STORE_FORMAT=$OPTARG;;
        [?])    usage;;
        esac
done

shift $((OPTIND - 1))

BASEAGENTCONFIG=$SPIRIT_HOME/config/agent/SPIRITAgent_1_0_BaseAgentConfig_orig.xml
DTCONFIG=$SPIRIT_HOME/config/agent/SPIRITAgent_1_0_DataTransportConfig_orig.xml
COMPCONFIG=$SPIRIT_HOME/config/agent/SPIRITAgent_1_0_SpiritComponentConfig_orig.xml
SECURITYPROPS=$SPIRIT_HOME/security/spirit_security.properties

if [ $# -lt 3 ]
then
	usage
fi

smgr_hostname=$1
smgr_port=$2
epassword=$3

if [ $4"x" = "x" ]
then
	platform_qualifier="Enterprise-"$smgr_hostname
else
	platform_qualifier=$4
fi
	
smgr_mgmt_https_port=10443
sed -i 's/"SPIRIT.LoggingServiceURL">.*<\/entry/"SPIRIT.LoggingServiceURL">https\:\/\/'$smgr_hostname':'$smgr_mgmt_https_port'\/LoggingService-LoggingService\/LoggingService<\/entry/' $BASEAGENTCONFIG

sed -i '/"Connection.Set"/ c\<entry key="Connection.Set">AvayaBase<\/entry>' $DTCONFIG

sed -i 's/"Connection.AvayaBase.PlatformQualifier">.*<\/entry/"Connection.AvayaBase.PlatformQualifier">'$platform_qualifier'<\/entry/' $DTCONFIG

sed -i 's/"Connection.AvayaBase.URL.0">.*<\/entry/"Connection.AvayaBase.URL.0">https\:\/\/'$smgr_hostname':'$smgr_mgmt_https_port'\/DataTransport_Servlet\/servlet\/TransportReceiverServlet<\/entry/' $DTCONFIG

sed -i 's/"Connection.AvayaBase.URL.1">.*<\/entry/"Connection.AvayaBase.URL.1">https\:\/\/'$smgr_hostname':'$smgr_mgmt_https_port'\/DataTransport_Servlet\/servlet\/TransportReceiverServlet<\/entry/' $DTCONFIG

cp $SPIRIT_HOME/config/agent/SPIRITAgent_1_0_SpiritComponentConfig_orig_SMGR.xml $COMPCONFIG

if [ $ALARMING_CONFIG = "false" ]
then
	sed -i '/<entry key.*com\.avaya\.spirit\.agent\.component\.SubAgentComponent.*/d' $COMPCONFIG

	sed -i '/<entry key.*com\.avaya\.spirit\.agent\.component\.AlarmingComponent.*/d' $COMPCONFIG
fi

sed -i 's/"Address.AgentHeartbeat">.*<\/entry/"Address.AgentHeartbeat">AgentHeartbeat@avaya.com., '$platform_qualifier'<\/entry/' $COMPCONFIG

sed -i 's/"Address.Inventory">.*<\/entry/"Address.Inventory">Inventory@avaya.com., '$platform_qualifier'<\/entry/' $COMPCONFIG

sed -i 's/"Address.ConfirmConfiguration">.*<\/entry/"Address.ConfirmConfiguration">ConfirmConfiguration@avaya.com., '$platform_qualifier'<\/entry/' $COMPCONFIG

sed -i 's/"Address.SNMP">.*<\/entry/"Address.SNMP">alarms@avaya.com., '$platform_qualifier'<\/entry/' $COMPCONFIG

sed -i 's/"Address.ProcessLog">.*<\/entry/"Address.ProcessLog">ProcessLog@avaya.com., '$platform_qualifier'<\/entry/' $COMPCONFIG

if [ $STORE_FORMAT = "BCFKS" ]
then
	sed -i 's/jks/bcfks/g' $SECURITYPROPS
	sed -i 's/JKS/BCFKS/g' $SECURITYPROPS
else
	sed -i 's/bcfks/jks/g' $SECURITYPROPS
	sed -i 's/BCFKS/JKS/g' $SECURITYPROPS
fi

if [ $GENERATE_CERTS = "true" ]
then
	cd $SPIRIT_HOME/TM_client/unix/
	sh EnableHostAgentSecurity_postinstall.bsh $smgr_hostname $smgr_port $epassword
	cd -
fi
