#!/bin/bash

# Make sure only root can run our script
if [ "$(id -u)" != "0" ]; then
   echo "This script must be run as root" 1>&2
   exit 1
fi

usage(){
	echo "Invalid arguments specified, correct usage ..."
	echo "$0 [-l] [-r] LOG_FILE_LIST"
	echo "-l : Lists the configured tail files one on each line"
	echo "-r : For removing specified log files from the list of tailed files."
	echo "LOG_FILE_LIST : Space separate list of log files to be added/removed"
	exit 1
}

if [ $# -lt 1 ]
then
	usage
fi

OPER="add"

while getopts rl opt
do      case "$opt" in
        r)      OPER="remove"; shift ;;
		l)		OPER="list"; shift ;;
        [?])    usage;;
        esac
done

BASEAGENTCONFIG=$SPIRIT_HOME/config/agent/SPIRITAgent_1_0_BaseAgentConfig_orig.xml

if [ $OPER = "list" ]
then
	grep "SPIRIT.tailFileName" $BASEAGENTCONFIG | cut -f2 -d'>' | cut -f1 -d'<'
	exit 0
fi

if [ $OPER = "add" ]
then
	highestTailFileNumber=`grep "SPIRIT.tailFileName.*" $BASEAGENTCONFIG | cut -f2 -d'"' | cut -f3 -d'.' | sort -g | tail -1`
	numOfLogFiles=$#
	lineNum=`grep -n "SPIRIT.tailFileName.$highestTailFileNumber" $BASEAGENTCONFIG | cut -f1 -d':'`

	nextLineNum=$highestTailFileNumber

	for logFile in $@ 
	do
		grep "<entry key=\"SPIRIT.tailFileName.*\">$logFile</entry>" $BASEAGENTCONFIG > /dev/null
		if [ $? != 0 ]
		then
			nextTailNumber=`expr $highestTailFileNumber + 1`
			sed -i '/SPIRIT.tailFileName.'$highestTailFileNumber'/a\
<entry key="SPIRIT.tailFileName.'$nextTailNumber'">'$logFile'<\/entry>' $BASEAGENTCONFIG
			highestTailFileNumber=`expr $highestTailFileNumber + 1`
		fi
	done
else
	for logFile in $@
	do
		lineNum=`grep -n "\"SPIRIT.tailFileName.*\">$logFile" $BASEAGENTCONFIG | cut -f1 -d':'`
		sed -i ''$lineNum' d' $BASEAGENTCONFIG
	done
fi
