#!/bin/bash

if [ $# -lt 3 ]
then
	echo "$0 snmpv3User authPass privPass"
	exit 1
fi

user=$1
authPass=$2
privPass=$3

snmptable -u $user -l authPriv -a MD5 -A $authPass -x AES -X $privPass -CH -Cf \| localhost 1.3.6.1.6.3.13.1.1 | grep "active" | cut -d\| -f1,2 > notification_table

snmptable -u $user -l authPriv -a MD5 -A $authPass -x AES -X $privPass -CH -Cf \| localhost 1.3.6.1.6.3.12.1.2 | grep "active" | cut -d\| -f1,2,5,6 > target_table

snmptable -u $user -l authPriv -a MD5 -A $authPass -x AES -X $privPass -CH -Cf \| -Ci localhost 1.3.6.1.6.3.12.1.3 | grep "active" | cut -d\| -f1,3,4 > target_params_table

rm -f output
for line in `cat notification_table`
do
	tag=`echo $line | cut -d\| -f1`
	matchTarget=`grep ".*|.*|.*$tag.*|.*" target_table`
	if [ $? = 0 ] 
	then
		paramTag=`echo $matchTarget | cut -d\| -f4`
		matchParam=`grep "'$paramTag'|.*" target_params_table`
		if [ $? = 0 ]
		then
			ipPortPartHex=`echo $matchTarget | cut -d"|" -f2 | sed 's/\"//g'`
			ipPart=`echo $ipPortPartHex | sed 's/.\{6\}$//g' | sed 's/[0-9a-fA-F][0-9a-fA-F]/0x&/g'`
			portPart="0x"`echo $ipPortPartHex | sed 's/.\{12\}//' | sed 's/ $//' | sed 's/ //g'`
			ip=`printf "%d.%d.%d.%d" $ipPart`
			port=`printf "%d" $portPart`
			type=`echo $line | cut -d"|" -f2`
			snmpV=`echo $matchParam | cut -d"|" -f2`
			secName=`echo $matchParam | cut -d"|" -f3`
			printf "%s %s %s %s v%s\n" $ip $port $secName $type $snmpV
		fi
	fi
done

rm -f notification_table
rm -f target_table
rm -f target_params_table
