#!/bin/bash
# This script is for testing Alarms for generating test Alarm and clearing test Alarm

usage(){
        echo "generateTestAlarm.sh -c -l LOG_LOCATION -p PRODUCT_TYPE"
        echo "-c : Send a clear test alarm"
        echo "-l LOG_LOCATION : Location of the log file into which this test event is updated"
        echo "-p PRODUCT_TYPE: Product Type (same as LogProductType in Supported Products File)"
        exit 1
}

LOCALHOSTNAME=`hostname`
CURRENTDATE=`date +"%b %d %T"`
PROCESSNAME="TESTALARM"
TIMEZONEYEAR=`date +"%:z %Y"`
SPIRITLOGLOCATION="${AVAYA_LOG}/mgmt/spiritlogs/spiritDebugAppender.log"
PRODUCTTYPE="com.avaya.mgmt"
ALARM_TYPE="alarm"

while getopts cl:p: o
do      case "$o" in
        c)      ALARM_TYPE="clear";;
        l)      SPIRITLOGLOCATION="$OPTARG";;
        p)      PRODUCTTYPE="$OPTARG";;
        [?])    usage;;
        esac
done

if [ $ALARM_TYPE = "alarm" ]
then
        #Test Alarm
        echo "<11>$CURRENTDATE $LOCALHOSTNAME $PROCESSNAME: $TIMEZONEYEAR 000 1 $PRODUCTTYPE | 1 com.avaya.test.alarm TEST_ALARM_GEN_0001 Test alarm" >> $SPIRITLOGLOCATION
        echo "Test alarm generated."
        exit 0
else
        #Clear Event
        echo "<14>$CURRENTDATE $LOCALHOSTNAME $PROCESSNAME: $TIMEZONEYEAR 000 1 $PRODUCTTYPE | 1 com.avaya.test.alarm TEST_ALARM_CLR_0000  Clear event for test alarm" >> $SPIRITLOGLOCATION
        echo "Clear event for test alarm generated."
        exit 0
fi