#!/bin/bash
### Getting Product ID for SPIRIT
## Usage
if [ -z "$1" ]; then
        echo "Missing Argument"
        echo "Usage: ./getProductID.sh ProductType"
        exit 1
fi

. /etc/profile

Line=`grep -n "<prodType>$1" $SPIRIT_HOME/config/agent/SPIRITAgent_1_0_supportedproducts_orig.xml | cut -d":" -f1`

if [ "$Line" = "" ]
then
        echo "Couldn't find product type $1"
        exit 1
fi

LineNo=`expr $Line - 1`

sed -n "$LineNo p" $SPIRIT_HOME/config/agent/SPIRITAgent_1_0_supportedproducts_orig.xml > tmp.txt

PType=`cat tmp.txt | cut -d">" -f2 | cut -d"<" -f1`

echo "ProductID for $1 is $PType"

rm -rf tmp.txt
