#!/bin/bash
# This script is for reinitializing the serviceability agent box's snmpd to a clean state.


VAR_SNMPD_CONF=/var/net-snmp/snmpd.conf
VAR_SNMPD_CONF_BAK=/var/net-snmp/snmpd.conf.bak
LOCAL_VAR_SNMPD_CONF=var.snmpd.conf

rm -f $LOCAL_VAR_SNMPD_CONF >> /dev/null
echo "Stopping existing snmpd service..."
service snmpd stop

if [ -f $VAR_SNMPD_CONF ]
then
	cp $VAR_SNMPD_CONF $LOCAL_VAR_SNMPD_CONF
	cp $VAR_SNMPD_CONF $VAR_SNMPD_CONF_BAK
	> $LOCAL_VAR_SNMPD_CONF
fi

if [ ! -d /var/net-snmp ]
then
	mkdir /var/net-snmp	
fi

echo "createUser initial MD5 avaya123 AES avaya123" >> $LOCAL_VAR_SNMPD_CONF
echo "createUser initial_md5_aes MD5 avaya123 AES avaya123" >> $LOCAL_VAR_SNMPD_CONF
echo "createUser initial_md5_des MD5 avaya123 DES avaya123" >> $LOCAL_VAR_SNMPD_CONF
echo "createUser initial_md5_none MD5 avaya123" >> $LOCAL_VAR_SNMPD_CONF
echo "createUser initial_sha_aes SHA avaya123 AES avaya123" >> $LOCAL_VAR_SNMPD_CONF
echo "createUser initial_sha_des SHA avaya123 DES avaya123" >> $LOCAL_VAR_SNMPD_CONF
echo "createUser initial_sha_none SHA avaya123" >> $LOCAL_VAR_SNMPD_CONF

cp $LOCAL_VAR_SNMPD_CONF $VAR_SNMPD_CONF
service snmpd restart

echo "Setting the reinitialized property to true"
MYCLASSPATH=$SPIRIT_HOME/lib/spiritAgent.jar:$SPIRIT_HOME/lib/spirit-common-api.jar:$SPIRIT_HOME/lib/avaya_logging_client.jar:$SPIRIT_HOME/lib/log4j-api.jar:$SPIRIT_HOME/lib/log4j-core.jar:$SPIRIT_HOME/lib/avaya_logging_formatter.jar

java -classpath $MYCLASSPATH com.avaya.spirit.agent.tools.cli.SpiritDynPropMgr "reinitialized" "true"

exit 0

