#!/bin/bash
### Setting OverrideMeId for SPIRIT

## Usage
if [ -z "$1" ]; then
        echo "Missing Argument"
        echo "Usage: ./setOverrideMeId.sh ProductType"
        exit 1
fi

. /etc/profile

SUPPORTPROD_XML=$SPIRIT_HOME/config/agent/SPIRITAgent_1_0_supportedproducts_orig.xml

Line=`grep -n -B1 "<prodType>$1</prodType>" $SUPPORTPROD_XML | head -1 | cut -d"-" -f1`
if [ "$Line" = "" ]
then
        echo "Couldn't find product type $1"
        exit 1
fi

mgElemId=`sed -n "$Line p" $SUPPORTPROD_XML | cut -d">" -f2 | cut -d"<" -f1`

grep -n "<overrideMeId>" $SPIRIT_HOME/config/agent/SPIRITAgent_1_0_supportedproducts_orig.xml | cut -d":" -f1 > /tmp/overrideMeIdLines.txt
for Line in `cat /tmp/overrideMeIdLines.txt`
do
	sed -i ''${Line}'s/overrideMeId>.*<\/overrideMeId/overrideMeId>'$mgElemId'<\/overrideMeId/' $SUPPORTPROD_XML
done

rm -rf /tmp/overrideMeIdLines.txt

