connect 'jdbc:derby:DB/agentDB;create=true';

-- ----------------------------------------------
-- DDL Statements for sequences
-- ----------------------------------------------

CREATE SEQUENCE "AGENT"."ALARM_AUX_KEYWORD_SQ"
    AS INTEGER
    START WITH -2147483648
    INCREMENT BY 1
    MAXVALUE 2147483647
    MINVALUE -2147483648
    NO CYCLE
;

CREATE SEQUENCE "AGENT"."ALARM_INSTANCE_SQ"
    AS INTEGER
    START WITH -2147483648
    INCREMENT BY 1
    MAXVALUE 2147483647
    MINVALUE -2147483648
    NO CYCLE
;

CREATE SEQUENCE "AGENT"."ALARM_OBJECT_SQ"
    AS INTEGER
    START WITH -2147483648
    INCREMENT BY 1
    MAXVALUE 2147483647
    MINVALUE -2147483648
    NO CYCLE
;

CREATE SEQUENCE "AGENT"."AUX_EVENT_ID_SQ"
    AS INTEGER
    START WITH -2147483648
    INCREMENT BY 1
    MAXVALUE 2147483647
    MINVALUE -2147483648
    NO CYCLE
;

CREATE SEQUENCE "AGENT"."AUX_KEYWORD_INSTANCE_SQ"
    AS INTEGER
    START WITH -2147483648
    INCREMENT BY 1
    MAXVALUE 2147483647
    MINVALUE -2147483648
    NO CYCLE
;

CREATE SEQUENCE "AGENT"."CHANGE_HISTORY_SQ"
    AS INTEGER
    START WITH -2147483648
    INCREMENT BY 1
    MAXVALUE 2147483647
    MINVALUE -2147483648
    NO CYCLE
;

CREATE SEQUENCE "AGENT"."FLT_CLR_PROCD_SQ"
    AS INTEGER
    START WITH -2147483648
    INCREMENT BY 1
    MAXVALUE 2147483647
    MINVALUE -2147483648
    NO CYCLE
;

CREATE SEQUENCE "AGENT"."NOTIF_AUX_KEYWORD_SQ"
    AS INTEGER
    START WITH -2147483648
    INCREMENT BY 1
    MAXVALUE 2147483647
    MINVALUE -2147483648
    NO CYCLE
;

CREATE SEQUENCE "AGENT"."OID_ALIAS_SQ"
    AS INTEGER
    START WITH -2147483648
    INCREMENT BY 1
    MAXVALUE 2147483647
    MINVALUE -2147483648
    NO CYCLE
;

CREATE SEQUENCE "AGENT"."OWNER_SQ"
    AS INTEGER
    START WITH -2147483648
    INCREMENT BY 1
    MAXVALUE 2147483647
    MINVALUE -2147483648
    NO CYCLE
;

CREATE SEQUENCE "AGENT"."PRD_SUPP_MATR_SQ"
    AS INTEGER
    START WITH -2147483648
    INCREMENT BY 1
    MAXVALUE 2147483647
    MINVALUE -2147483648
    NO CYCLE
;

CREATE SEQUENCE "AGENT"."SUPP_EXCP_SQ"
    AS INTEGER
    START WITH -2147483648
    INCREMENT BY 1
    MAXVALUE 2147483647
    MINVALUE -2147483648
    NO CYCLE
;

CREATE SEQUENCE "AGENT"."VARBIND_DEF_SQ"
    AS INTEGER
    START WITH -2147483648
    INCREMENT BY 1
    MAXVALUE 2147483647
    MINVALUE -2147483648
    NO CYCLE
;

CREATE SEQUENCE "AGENT"."VARBIND_SQ"
    AS INTEGER
    START WITH -2147483648
    INCREMENT BY 1
    MAXVALUE 2147483647
    MINVALUE -2147483648
    NO CYCLE
;

-- ----------------------------------------------
-- DDL Statements for tables
-- ----------------------------------------------

CREATE TABLE "AGENT"."VARBIND" ("ID" BIGINT NOT NULL, "ALARMRULE_NOTIFICATIONOID" VARCHAR(1407), "VARBINDDEF_ID" BIGINT);

CREATE TABLE "AGENT"."ALARMDEF" ("ALARMOBJECTTYPE" VARCHAR(255) NOT NULL, "ALARMLISTNAME" VARCHAR(255), "DESCRIPTION" VARCHAR(255), "REVISION" VARCHAR(255), "SCHEMAVERSION" VARCHAR(255), "OWNER_ID" BIGINT);

CREATE TABLE "AGENT"."OIDALIAS" ("ID" BIGINT NOT NULL, "ALIAS" VARCHAR(255), "MIBMODULE" VARCHAR(255), "OID" VARCHAR(255), "ALARMDEF_ALARMOBJECTTYPE" VARCHAR(255));

CREATE TABLE "AGENT"."ALARMOBJECT" ("ID" BIGINT NOT NULL, "FIELD" INTEGER NOT NULL, "REGEXP" VARCHAR(255), "VARBIND_ID" BIGINT);

CREATE TABLE "AGENT"."VARBINDDEF" ("ID" BIGINT NOT NULL, "DISPLAYHINT" VARCHAR(255), "NAME" VARCHAR(255), "OID" VARCHAR(255), "TYPE" INTEGER NOT NULL, "ALARMDEF_ALARMOBJECTTYPE" VARCHAR(255));

CREATE TABLE "AGENT"."AUXEVENTID" ("ID" BIGINT NOT NULL, "ALARMOBJECTTYPE" VARCHAR(255), "AUXID" INTEGER NOT NULL, "ALARMRULE_NOTIFICATIONOID" VARCHAR(1407));

CREATE TABLE "AGENT"."NOTIFICATIONAUXKEYWORD" ("ID" BIGINT NOT NULL, "AUXKEYWORD" VARCHAR(255), "ALARMRULE_NOTIFICATIONOID" VARCHAR(1407));

CREATE TABLE "AGENT"."AUXKEYWORDINSTANCE" ("ID" BIGINT NOT NULL, "FIELD" INTEGER NOT NULL, "REGEXP" VARCHAR(255), "VARBIND_ID" BIGINT);

CREATE TABLE "AGENT"."FAULTCLRPROCEDURE" ("ID" BIGINT NOT NULL, "FLTCLRPROC" VARCHAR(255), "ALARMRULE_NOTIFICATIONOID" VARCHAR(1407));

CREATE TABLE "AGENT"."CHANGEHISTORY" ("ID" BIGINT NOT NULL, "CHANGE" VARCHAR(255), "TIMESTAMP" TIMESTAMP, "ALARMDEF_ALARMOBJECTTYPE" VARCHAR(255));

CREATE TABLE "AGENT"."PRODUCTSUPPORTMATRIX" ("ID" BIGINT NOT NULL, "NAME" VARCHAR(255), "VENDOR" VARCHAR(255), "VERSION" VARCHAR(255), "ALARMDEF_ALARMOBJECTTYPE" VARCHAR(255));

CREATE TABLE "AGENT"."OWNER" ("ID" BIGINT NOT NULL, "EMAIL" VARCHAR(255), "NAME" VARCHAR(255), "TEAM" VARCHAR(255));

CREATE TABLE "AGENT"."SUPPORTEXCEPTION" ("ID" BIGINT NOT NULL, "NOTSUPPORTEDFROMVERSION" VARCHAR(255), "ALARMRULE_NOTIFICATIONOID" VARCHAR(1407));

CREATE TABLE "AGENT"."ALARMAUXKEYWORD" ("ID" BIGINT NOT NULL, "AUXKEYWORD" VARCHAR(255), "ALARMDEF_ALARMOBJECTTYPE" VARCHAR(255));

CREATE TABLE "AGENT"."ALARMINSTANCE" ("ID" BIGINT NOT NULL, "FIELD" INTEGER NOT NULL, "REGEXP" VARCHAR(255), "VARBIND_ID" BIGINT);

CREATE TABLE "AGENT"."ALARMRULE" ("NOTIFICATIONOID" VARCHAR(1407) NOT NULL, "ALARMNAME" VARCHAR(255), "CATEGORY" VARCHAR(255), "DESCRIPTION" VARCHAR(255), "EVENTID" INTEGER NOT NULL, "FORMAT" VARCHAR(2000), "SEVERITY" VARCHAR(255), "TYPE" VARCHAR(255), "ALARMDEF_ALARMOBJECTTYPE" VARCHAR(255));

CREATE TABLE "AGENT"."ALARMACTIVEVARIABLEENTRY" ("INSTANCEOID" VARCHAR (1407) FOR BIT DATA NOT NULL, "ALARMACTIVEVARIABLECOUNTER32VAL" BIGINT NOT NULL, "ALARMACTIVEVARIABLECOUNTER64VAL" BIGINT NOT NULL, "ALARMACTIVEVARIABLEID" VARCHAR (1407), "ALARMACTIVEVARIABLEINDEX" BIGINT NOT NULL, "ALARMACTIVEVARIABLEINTEGER32VAL" INTEGER NOT NULL, "ALARMACTIVEVARIABLEIPADDRESSVAL" VARCHAR(255), "ALARMACTIVEVARIABLEOCTETSTRINGVAL" VARCHAR (32672) FOR BIT DATA, "ALARMACTIVEVARIABLEOIDVAL" VARCHAR (1407), "ALARMACTIVEVARIABLEOPAQUEVAL" VARCHAR (32672) FOR BIT DATA, "ALARMACTIVEVARIABLETIMETICKSVAL" BIGINT NOT NULL, "ALARMACTIVEVARIABLEUNSIGNED32VAL" BIGINT NOT NULL, "ALARMACTIVEVARIABLEVALUETYPE" INTEGER, "ALARMACTIVEENTRY_INSTANCEOID" VARCHAR (1407) FOR BIT DATA);

CREATE TABLE "AGENT"."ALARMACTIVEENTRY" ("INSTANCEOID" VARCHAR (1407) FOR BIT DATA NOT NULL, "ALARMACTIVECONTEXTNAME" VARCHAR (32) FOR BIT DATA, "ALARMACTIVEDATAANDTIME" BIGINT NOT NULL, "ALARMACTIVEDESCRIPTION" VARCHAR (255) FOR BIT DATA, "ALARMACTIVEENGINEADDRESS" VARCHAR (255) FOR BIT DATA, "ALARMACTIVEENGINEADDRESSTYPE" INTEGER NOT NULL, "ALARMACTIVEENGINEID" VARCHAR (32) FOR BIT DATA, "ALARMACTIVEINDEX" BIGINT NOT NULL, "ALARMACTIVELOGPOINTER" VARCHAR (1407), "ALARMACTIVEMODELPOINTER" VARCHAR (1407), "ALARMACTIVENOTIFICATIONID" VARCHAR (1407), "ALARMACTIVERESOURCEID" VARCHAR (1407), "ALARMACTIVESPECIFICPOINTER" VARCHAR (1407), "ALARMACTIVEVARIABLES" INTEGER NOT NULL, "ALARMLISTNAME" VARCHAR(32), "ALARMACTIVEACKSTATUS" BOOLEAN NOT NULL);

CREATE TABLE "AGENT"."ALARMACTIVEENTRY_ALARMACTIVEVARIABLEENTRY" ("ALARMACTIVEENTRY_INSTANCEOID" VARCHAR (1407) FOR BIT DATA NOT NULL, "ALARMACTIVEVARIABLELIST_INSTANCEOID" VARCHAR (1407) FOR BIT DATA NOT NULL);

-- ----------------------------------------------
-- DDL Statements for keys
-- ----------------------------------------------

-- primary/unique
ALTER TABLE "AGENT"."PRODUCTSUPPORTMATRIX" ADD CONSTRAINT "SQL110111172536850" PRIMARY KEY ("ID");

ALTER TABLE "AGENT"."CHANGEHISTORY" ADD CONSTRAINT "SQL110111172534900" PRIMARY KEY ("ID");

ALTER TABLE "AGENT"."VARBINDDEF" ADD CONSTRAINT "SQL110111172538020" PRIMARY KEY ("ID");

ALTER TABLE "AGENT"."ALARMINSTANCE" ADD CONSTRAINT "SQL110111172533840" PRIMARY KEY ("ID");

ALTER TABLE "AGENT"."OIDALIAS" ADD CONSTRAINT "SQL110111172536200" PRIMARY KEY ("ID");

ALTER TABLE "AGENT"."ALARMDEF" ADD CONSTRAINT "SQL110111172533320" PRIMARY KEY ("ALARMOBJECTTYPE");

ALTER TABLE "AGENT"."NOTIFICATIONAUXKEYWORD" ADD CONSTRAINT "SQL110111172535990" PRIMARY KEY ("ID");

ALTER TABLE "AGENT"."ALARMAUXKEYWORD" ADD CONSTRAINT "SQL110111172533090" PRIMARY KEY ("ID");

ALTER TABLE "AGENT"."FAULTCLRPROCEDURE" ADD CONSTRAINT "SQL110111172535660" PRIMARY KEY ("ID");

ALTER TABLE "AGENT"."ALARMOBJECT" ADD CONSTRAINT "SQL110111172533960" PRIMARY KEY ("ID");

ALTER TABLE "AGENT"."OWNER" ADD CONSTRAINT "SQL110111172536700" PRIMARY KEY ("ID");

ALTER TABLE "AGENT"."AUXKEYWORDINSTANCE" ADD CONSTRAINT "SQL110111172534760" PRIMARY KEY ("ID");

ALTER TABLE "AGENT"."VARBIND" ADD CONSTRAINT "SQL110111172537740" PRIMARY KEY ("ID");

ALTER TABLE "AGENT"."AUXEVENTID" ADD CONSTRAINT "SQL110111172534310" PRIMARY KEY ("ID");

ALTER TABLE "AGENT"."SUPPORTEXCEPTION" ADD CONSTRAINT "SQL110111172536990" PRIMARY KEY ("ID");

ALTER TABLE "AGENT"."ALARMRULE" ADD CONSTRAINT "SQL110111172534100" PRIMARY KEY ("NOTIFICATIONOID");

ALTER TABLE "AGENT"."ALARMACTIVEENTRY_ALARMACTIVEVARIABLEENTRY" ADD CONSTRAINT "SQL110117114559500" UNIQUE ("ALARMACTIVEVARIABLELIST_INSTANCEOID");

ALTER TABLE "AGENT"."ALARMACTIVEENTRY" ADD CONSTRAINT "SQL110117114559450" PRIMARY KEY ("INSTANCEOID");

ALTER TABLE "AGENT"."ALARMACTIVEVARIABLEENTRY" ADD CONSTRAINT "SQL110117114559520" PRIMARY KEY ("INSTANCEOID");


-- foreign
ALTER TABLE "AGENT"."PRODUCTSUPPORTMATRIX" ADD CONSTRAINT "FKD024FFE15923E122" FOREIGN KEY ("ALARMDEF_ALARMOBJECTTYPE") REFERENCES "AGENT"."ALARMDEF" ("ALARMOBJECTTYPE") ON DELETE NO ACTION ON UPDATE NO ACTION;

ALTER TABLE "AGENT"."CHANGEHISTORY" ADD CONSTRAINT "FK2C8412A45923E122" FOREIGN KEY ("ALARMDEF_ALARMOBJECTTYPE") REFERENCES "AGENT"."ALARMDEF" ("ALARMOBJECTTYPE") ON DELETE NO ACTION ON UPDATE NO ACTION;

ALTER TABLE "AGENT"."VARBINDDEF" ADD CONSTRAINT "FK7A6C2DA15923E122" FOREIGN KEY ("ALARMDEF_ALARMOBJECTTYPE") REFERENCES "AGENT"."ALARMDEF" ("ALARMOBJECTTYPE") ON DELETE NO ACTION ON UPDATE NO ACTION;

ALTER TABLE "AGENT"."ALARMINSTANCE" ADD CONSTRAINT "FK47A6C1E6919CA20B" FOREIGN KEY ("VARBIND_ID") REFERENCES "AGENT"."VARBIND" ("ID") ON DELETE NO ACTION ON UPDATE NO ACTION;

ALTER TABLE "AGENT"."OIDALIAS" ADD CONSTRAINT "FK6F566AC65923E122" FOREIGN KEY ("ALARMDEF_ALARMOBJECTTYPE") REFERENCES "AGENT"."ALARMDEF" ("ALARMOBJECTTYPE") ON DELETE NO ACTION ON UPDATE NO ACTION;

ALTER TABLE "AGENT"."ALARMDEF" ADD CONSTRAINT "FK5D4C8814854BFBEB" FOREIGN KEY ("OWNER_ID") REFERENCES "AGENT"."OWNER" ("ID") ON DELETE NO ACTION ON UPDATE NO ACTION;

ALTER TABLE "AGENT"."NOTIFICATIONAUXKEYWORD" ADD CONSTRAINT "FK9D507DF0E06050B" FOREIGN KEY ("ALARMRULE_NOTIFICATIONOID") REFERENCES "AGENT"."ALARMRULE" ("NOTIFICATIONOID") ON DELETE NO ACTION ON UPDATE NO ACTION;

ALTER TABLE "AGENT"."ALARMAUXKEYWORD" ADD CONSTRAINT "FKFA8F73965923E122" FOREIGN KEY ("ALARMDEF_ALARMOBJECTTYPE") REFERENCES "AGENT"."ALARMDEF" ("ALARMOBJECTTYPE") ON DELETE NO ACTION ON UPDATE NO ACTION;

ALTER TABLE "AGENT"."FAULTCLRPROCEDURE" ADD CONSTRAINT "FKC7C80ACCE06050B" FOREIGN KEY ("ALARMRULE_NOTIFICATIONOID") REFERENCES "AGENT"."ALARMRULE" ("NOTIFICATIONOID") ON DELETE NO ACTION ON UPDATE NO ACTION;

ALTER TABLE "AGENT"."ALARMOBJECT" ADD CONSTRAINT "FK5FADF0D0919CA20B" FOREIGN KEY ("VARBIND_ID") REFERENCES "AGENT"."VARBIND" ("ID") ON DELETE NO ACTION ON UPDATE NO ACTION;

ALTER TABLE "AGENT"."AUXKEYWORDINSTANCE" ADD CONSTRAINT "FKA9E1B65A919CA20B" FOREIGN KEY ("VARBIND_ID") REFERENCES "AGENT"."VARBIND" ("ID") ON DELETE NO ACTION ON UPDATE NO ACTION;

ALTER TABLE "AGENT"."VARBIND" ADD CONSTRAINT "FK715297C4E06050B" FOREIGN KEY ("ALARMRULE_NOTIFICATIONOID") REFERENCES "AGENT"."ALARMRULE" ("NOTIFICATIONOID") ON DELETE NO ACTION ON UPDATE NO ACTION;

ALTER TABLE "AGENT"."VARBIND" ADD CONSTRAINT "FK715297C4AE06189" FOREIGN KEY ("VARBINDDEF_ID") REFERENCES "AGENT"."VARBINDDEF" ("ID") ON DELETE NO ACTION ON UPDATE NO ACTION;

ALTER TABLE "AGENT"."AUXEVENTID" ADD CONSTRAINT "FK8CA65211E06050B" FOREIGN KEY ("ALARMRULE_NOTIFICATIONOID") REFERENCES "AGENT"."ALARMRULE" ("NOTIFICATIONOID") ON DELETE NO ACTION ON UPDATE NO ACTION;

ALTER TABLE "AGENT"."SUPPORTEXCEPTION" ADD CONSTRAINT "FK82D50D60E06050B" FOREIGN KEY ("ALARMRULE_NOTIFICATIONOID") REFERENCES "AGENT"."ALARMRULE" ("NOTIFICATIONOID") ON DELETE NO ACTION ON UPDATE NO ACTION;

ALTER TABLE "AGENT"."ALARMRULE" ADD CONSTRAINT "FK4C4B14CD5923E122" FOREIGN KEY ("ALARMDEF_ALARMOBJECTTYPE") REFERENCES "AGENT"."ALARMDEF" ("ALARMOBJECTTYPE") ON DELETE NO ACTION ON UPDATE NO ACTION;

ALTER TABLE "AGENT"."ALARMACTIVEENTRY_ALARMACTIVEVARIABLEENTRY" ADD CONSTRAINT "FK471949A35491D081" FOREIGN KEY ("ALARMACTIVEENTRY_INSTANCEOID") REFERENCES "AGENT"."ALARMACTIVEENTRY" ("INSTANCEOID") ON DELETE NO ACTION ON UPDATE NO ACTION;

ALTER TABLE "AGENT"."ALARMACTIVEENTRY_ALARMACTIVEVARIABLEENTRY" ADD CONSTRAINT "FK471949A3D3EDF95B" FOREIGN KEY ("ALARMACTIVEVARIABLELIST_INSTANCEOID") REFERENCES "AGENT"."ALARMACTIVEVARIABLEENTRY" ("INSTANCEOID") ON DELETE NO ACTION ON UPDATE NO ACTION;

ALTER TABLE "AGENT"."ALARMACTIVEVARIABLEENTRY" ADD CONSTRAINT "FKD20743FF5491D081" FOREIGN KEY ("ALARMACTIVEENTRY_INSTANCEOID") REFERENCES "AGENT"."ALARMACTIVEENTRY" ("INSTANCEOID") ON DELETE NO ACTION ON UPDATE NO ACTION;

exit;