#!/bin/bash


# check if user is root - do a sudo if not
[ $UID -eq 0 ] || exec sudo $0 $@


JAVAFILE=/usr/lib/jvm/java-1.8.0/jre/lib/security/java.security

# check if the TLSv1  present or not
grep ^[[:blank:]]*jdk.tls.disabledAlgorithms "$JAVAFILE" | grep -E "TLSv1*, | TLSv1" >/dev/null
if [ $? -ne 0 ]
then
        #add TLS versions in jdk.tls.disabledAlgorithms
        sed -i 's/^[[:blank:]]*jdk.tls.disabledAlgorithms=/&TLSv1, /' $JAVAFILE
fi


# check if the TLSv1.1 present or not
grep ^[[:blank:]]*jdk.tls.disabledAlgorithms "$JAVAFILE" | grep -w "TLSv1\.1" >/dev/null
if [ $? -ne 0 ]
then
	#add TLS versions in jdk.tls.disabledAlgorithms
	sed -i 's/^[[:blank:]]*jdk.tls.disabledAlgorithms=/&TLSv1.1, /' $JAVAFILE 
fi
