

#STIGs related to audit fixed in this file :
#RHEL-07-030330	RHEL-07-030360  RHEL-07-030370	RHEL-07-030380	RHEL-07-030390	RHEL-07-030400	RHEL-07-030410	RHEL-07-030420	RHEL-07-030430
#RHEL-07-030440	RHEL-07-030450	RHEL-07-030460	RHEL-07-030470	RHEL-07-030480	RHEL-07-030490	RHEL-07-030500	RHEL-07-030510
#RHEL-07-030520	RHEL-07-030530	RHEL-07-030540	RHEL-07-030550	RHEL-07-030740	RHEL-07-030819	RHEL-07-030820
#RHEL-07-030821	RHEL-07-030830	RHEL-07-030880	RHEL-07-030890	RHEL-07-030900	RHEL-07-030910	RHEL-07-030920
#RHEL-07-030200
	

LOG=/var/log/auditStigs.log
AUDIT_FILE="/etc/audit/rules.d/audit.rules"
AUDITD_CONF="/etc/audit/auditd.conf"
AUDISP_REMOTE="/etc/audisp/plugins.d/au-remote.conf"

echo "Start RHEL-07-030590 All uses of the setfiles command must be audited." > $LOG
if ! grep "setfiles" $AUDIT_FILE
then
  echo '-a always,exit -F path=/usr/sbin/setfiles -F auid>=1000 -F auid!=4294967295 -k privileged-priv_change' >> $AUDIT_FILE
fi
echo "End RHEL-07-030590" >> $LOG

#-w /var/log/tallylog -p wa -k logins

echo "Start RHEL-07-030600 The operating system must generate audit records for all successful/unsuccessful account access count events."  >> $LOG
if ! grep "tallylog" $AUDIT_FILE
then
  echo '-w /var/log/tallylog -p wa -k logins' >> $AUDIT_FILE
fi
echo "End RHEL-07-030600" >> $LOG

echo "Start RHEL-07-030819 All uses of the create_module command must be audited." >> $LOG
if ! grep -iw create_module $AUDIT_FILE
then
   echo '-a always,exit -F arch=b64 -S create_module -k module-change' >> $AUDIT_FILE
fi
echo "End RHEL-07-030819" >> $LOG

echo "Start RHEL-07-030360 The Red Hat Enterprise Linux operating system must audit all executions of privileged functions." >> $LOG
if ! grep -iw execve $AUDIT_FILE
then
   echo "-a always,exit -F arch=b32 -S execve -C uid!=euid -F euid=0 -k setuid" >> $AUDIT_FILE
   echo "-a always,exit -F arch=b64 -S execve -C uid!=euid -F euid=0 -k setuid" >> $AUDIT_FILE
   echo "-a always,exit -F arch=b32 -S execve -C uid!=euid -F euid=0 -k setgid" >> $AUDIT_FILE
   echo "-a always,exit -F arch=b64 -S execve -C uid!=euid -F euid=0 -k setgid" >> $AUDIT_FILE
fi
echo "End RHEL-07-030360" >> $LOG

echo "Start RHEL-07-030370 The Red Hat Enterprise Linux operating system must audit all uses of the chown syscall." >> $LOG
if ! grep -iw 'b32.*chown' $AUDIT_FILE
then
   echo "-a always,exit -F arch=b32 -S chmod -S chown -S fchmodat -S fchown -S fchownat -S fremovexattr -S fsetxattr -S lchown -S lremovexattr -S lsetxattr -S removexattr -S fchmod -S setxattr -F auid=0 -k perm_mod" >> $AUDIT_FILE
   echo "-a always,exit -F arch=b32 -S chmod -S chown -S fchmodat -S fchown -S fchownat -S fremovexattr -S fsetxattr -S lchown -S lremovexattr -S lsetxattr -S removexattr -S fchmod -S setxattr -F auid>=1000 -F auid!=4294967295 -k perm_mod" >> $AUDIT_FILE
fi
echo "End RHEL-07-030370" >> $LOG

echo "Start RHEL-07-030500 The Red Hat Enterprise Linux operating system must audit all uses of the creat syscall." >> $LOG
if ! grep -iw 'b32.*creat' $AUDIT_FILE
then
        echo "-a always,exit -F arch=b32 -S open,creat,truncate,ftruncate,openat,open_by_handle_at -F exit=-EACCES -F auid>=1000 -F auid!=4294967295 -k access" >> $AUDIT_FILE
        echo "-a always,exit -F arch=b32 -S open,creat,truncate,ftruncate,openat,open_by_handle_at -F exit=-EACCES -F auid=0 -k access" >> $AUDIT_FILE
        echo "-a always,exit -F arch=b32 -S open,creat,truncate,ftruncate,openat,open_by_handle_at -F exit=-EPERM -F auid>=1000 -F auid!=4294967295 -k access" >> $AUDIT_FILE
        echo "-a always,exit -F arch=b32 -S open,creat,truncate,ftruncate,openat,open_by_handle_at -F exit=-EPERM -F auid=0 -k access" >> $AUDIT_FILE
fi
echo "End RHEL-07-030500" >> $LOG

echo "Start RHEL-07-030740 The Red Hat Enterprise Linux operating system must audit all uses of the mount command and syscall." >> $LOG
if grep -iw 'ARCH.*mount.*export' $AUDIT_FILE
then
       sed -i '/ARCH.*mount.*export/d' $AUDIT_FILE
fi

if ! grep -iw 'ARCH.*privileged-mount' $AUDIT_FILE
then
       echo "-a always,exit -F arch=$ARCH -S mount -F auid>=1000 -F auid!=4294967295 -k privileged-mount" >> $AUDIT_FILE
       echo "-a always,exit -F arch=$ARCH -S mount -F auid=0 -k privileged-mount" >> $AUDIT_FILE
fi

if ! grep -iw 'b32.*mount' $AUDIT_FILE
then
       echo "-a always,exit -F arch=b32 -S mount -F auid>=1000 -F auid!=4294967295 -k privileged-mount" >> $AUDIT_FILE
       echo "-a always,exit -F arch=b32 -S mount -F auid=0 -k privileged-mount" >> $AUDIT_FILE
fi
echo "End RHEL-07-030740" >> $LOG

echo "Start RHEL-07-030820 The Red Hat Enterprise Linux operating system must audit all uses of the init_module syscall." >> $LOG
if ! grep -iw 'b32.*init_module' $AUDIT_FILE
then
       echo "-a always,exit -F arch=b32 -S init_module -k module-change" >> $AUDIT_FILE
fi
echo "End RHEL-07-030820" >> $LOG

echo "Start RHEL-07-030830 The Red Hat Enterprise Linux operating system must audit all uses of the delete_module syscall." >> $LOG
if ! grep -iw 'b32.*delete_module' $AUDIT_FILE
then
       echo "-a always,exit -F arch=b32 -S delete_module -k module-change" >> $AUDIT_FILE
fi
echo "End RHEL-07-030830" >> $LOG

echo "Start RHEL-07-030821 The Red Hat Enterprise Linux operating system must audit all uses of the finit_module syscall." >> $LOG
if ! grep -iw 'b32.*finit_module' $AUDIT_FILE
then
       echo "-a always,exit -F arch=b32 -S finit_module -k module-change" >> $AUDIT_FILE
fi
echo "End RHEL-07-030821" >> $LOG

echo "Start RHEL-07-030819 The Red Hat Enterprise Linux operating system must audit all uses of the create_module syscall." >> $LOG
if ! grep -iw 'b32.*create_module' $AUDIT_FILE
then
       echo "-a always,exit -F arch=b32 -S create_module -k module-change" >> $AUDIT_FILE
fi
echo "End RHEL-07-030819" >> $LOG

echo "Start RHEL-07-030880" >> $LOG
if ! grep -iw 'b32.*rename' $AUDIT_FILE
then
       echo "-a always,exit -F arch=b32 -S rmdir -S unlink -S unlinkat -S rename -S renameat -F auid>=1000 -F auid!=4294967295 -k delete" >> $AUDIT_FILE
       echo "-a always,exit -F arch=b32 -S rmdir -S unlink -S unlinkat -S rename -S renameat -F auid=0 -k delete" >> $AUDIT_FILE
fi
echo "End RHEL-07-030880" >> $LOG

echo "Start RHEL-07-030330" >> $LOG
    audit_size=500
    total=`df -m /var/log/audit | awk 'FNR==2{print}' | awk '{print $4}'` ; audit_size=$(echo $total*0.25 |bc) ; audit_size=${audit_size%.*}
    current_audit_size=`grep -w space_left $AUDITD_CONF | cut -d'=' -f2`
if [ $audit_size -ne $current_audit_size ];then
    sed -i '/^space_left\b/d' $AUDITD_CONF
    echo "space_left = $audit_size" >> $AUDITD_CONF
fi
echo "End RHEL-07-030330" >> $LOG

echo "Start RHEL-07-030200"
if [ -f $AUDISP_REMOTE ];then
  sed -i -e 's/active = .*/active = yes/' $AUDISP_REMOTE
fi
echo "End RHEL-07-030200"



