#!/bin/bash
# This script is for testing Alarms for generating test Alarm

usage(){
        echo "generateTestAlarm.sh -l LOG_LOCATION -p PRODUCT_TYPE"
        echo "-l LOG_LOCATION : Location of the log file into which this test event is updated"
        echo "-p PRODUCT_TYPE: Product Type (same as LogProductType in Supported Products File)"
        exit 1
}

LOCALHOSTNAME="esxi-host"
CURRENTDATE=`date +"%b %d %T"`
PROCESSNAME="TESTALARM"
TIMEZONEYEAR=`date +"%:z %Y"`
SPIRITLOGLOCATION="/var/log/remote.log"
PRODUCTTYPE="com.avaya.avp"
ALARM_TYPE="alarm"

while getopts l:p: o
do      case "$o" in
        l)      SPIRITLOGLOCATION="$OPTARG";;
        p)      PRODUCTTYPE="$OPTARG";;
        [?])    usage;;
        esac
done

if [ $ALARM_TYPE = "alarm" ]
then
        #Test Alarm
        echo "<11>$CURRENTDATE $LOCALHOSTNAME $PROCESSNAME: $TIMEZONEYEAR 000 1 $PRODUCTTYPE | 1 com.avaya.avp TEST_ALARM Test alarm" >> $SPIRITLOGLOCATION
        echo "Test alarm generated."
        exit 0
fi
