#!/usr/bin/env python

import sys
import time
import socket
import syslog
import subprocess
import os
import threading
import signal
import select
import argparse

syslog.openlog('loginmon', syslog.LOG_CONS, syslog.LOG_LOCAL5)

# List of fault types
setFaultIds = {
    1   : 'TEST_AVPU',
    2   : 'AUTH_FAULT',
    3   : 'ACCESS_FAULT',
    4   : 'AUDIT_FAULT',
    5   : 'CERTIFICATE_REVOCATION_FAULT'
}

clearFaultIds = {
    4   : 'AUDIT_CLEAR',
}

setFaultIdsStr = {
    1   : 'Test Alarm',
    2   : 'Authentication Fault',
    3   : 'Authorization Fault',
    4   : 'Audit Fault',
    5   : 'Certificate Revocation Fault'
}

clearFaultIdsStr = {
    4   : 'Clear Audit Fault',
}


def listAlarms(list):
   if ( 'setlist' in args.idlist ):
      print "Choose one Alarm Id to set"
      for id in setFaultIds.keys():
         print "{} - for {}".format(id, setFaultIdsStr[id])
   else:   
      print "Choose one Alarm Id to clear"
      for id in clearFaultIds.keys():
         print "{} - for {}".format(id, clearFaultIdsStr[id])


def generateAlarm(args):
   almId = 1
   ctype = setFaultIds[1]
   prtType = "generated."
   if args.set > 0:
      if args.set in setFaultIds.keys():
         almId = args.set
         ctype = setFaultIds[almId]
      else:
         print "Incorrect Alarm Id."
         return
   if args.clear > 0:
      if args.clear in clearFaultIds.keys():
         almId = args.clear
         ctype = clearFaultIds[almId]
         prtType = "cleared."
      else:
         print "Incorrect clear Alarm Id."
         return

   try:
      syslog.syslog(syslog.LOG_ALERT, ctype + " " + '" Test Alarm"')
      print "Alarm {} is {}".format(ctype, prtType)
   except:
      print "Invalid Alarm Id to be generated"
      return


if __name__ == "__main__":
   parser = argparse.ArgumentParser(prog='test_alarm')
   group = parser.add_mutually_exclusive_group(required=True)
   group.add_argument('-s', '--set', dest='set', action="store",
     type=int, help='set an alarm to be generated', required=False)
   group.add_argument('-c', '--clear', dest='clear', action="store",
     type=int, help="clear an alarm" , required=False)
   group.add_argument(
    '-l',
    '--list',
    nargs='+',
    dest='idlist',
    choices=['setlist', 'clearlist'],
    help='lists Alarm Ids to be used with set or clear.',
    )
   args = parser.parse_args()
   if args.set > 0 or args.clear > 0:
      generateAlarm(parser.parse_args())
   if args.idlist != None:
      if ( 'setlist' in args.idlist or 'clearlist' in args.idlist):
         listAlarms(args.idlist)

