#!/bin/bash
#script to get and set filter messages for remote.log
usage()
{
printf " Type \n 1.'list' to get list of strings currenty used for the filter. \n 2.'add' to add new strings to current filter.\n 3.'delete' to remove a specific string from current set of strings. \n 4.'update' to update a specific string from current set of strings.\n "
}


get_strings()
{
input="/opt/avaya/common_services/filter_strings"
num=1
check=1
if [ -s /opt/avaya/common_services/filter_strings ]; then
  while IFS= read -r line
  do
    echo "$num.$line"
    ((num++))
  done < "$input"
else
  echo "No patterns have been set."
  check=0	 
fi
}

#To add a new pattern.
add_strings()
{
a="y"
while [ "${a,,}" = "y" ]
do
  echo "Please enter the string"
  read ip_string
  echo $ip_string >> /opt/avaya/common_services/filter_strings
  sed -i '/^if ($programname.*/i if ($msg contains '\'"$ip_string"\'') then {stop}' /etc/rsyslog.d/remotelogs.conf
  echo " Do you want to continue (y/n) "
  read a
systemctl restart rsyslog.service
done	
}

#To update specific pattern.
update_string()
{
echo "The current string patterns are as follows:"
get_strings
if [ $check -ne 0 ]; then 
echo "Enter the index number which you want to update"
read N
line=$(grep -n '^if $syslogseverity.*' /etc/rsyslog.d/remotelogs.conf | cut -d: -f 1)
echo "Enter the new string"
read inp
sed -i "${N}s/.*/${inp}/" /opt/avaya/common_services/filter_strings
N=$((N+line))
sed -i ''"$N"'s/.*/if ($msg contains '\'"$inp"\'') then {stop}/' /etc/rsyslog.d/remotelogs.conf
echo "After upating the patterns are:"
get_strings
systemctl restart rsyslog.service
fi
}

#To delete a specific pattern.
delete_string()
{
echo "The current string patterns are as follows:"
get_strings
if [ $check -ne 0 ]; then
echo "Enter the index number which you want to delete"
read N
line=$(grep -n '^if $syslogseverity.*' /etc/rsyslog.d/remotelogs.conf | cut -d: -f 1)
sed -i "${N}d" /opt/avaya/common_services/filter_strings
N=$((N+line))
sed -i "${N}d" /etc/rsyslog.d/remotelogs.conf
echo "After deleting the patterns are:"
get_strings
systemctl restart rsyslog.service
fi
}

#Main execution starts from here
if [ -z "$1" ]; then
  usage
else
  case $1 in
        "list")
                echo "The current string patterns are as follows:"
                get_strings
                ;;
        "add")
		cp -pf /etc/rsyslog.d/remotelogs.conf /etc/rsyslog.d/remotelogs.conf.bak
                add_strings
		echo " After adding new strings the patterns are :"
		get_strings
                ;;
        "delete")
		cp -pf /etc/rsyslog.d/remotelogs.conf /etc/rsyslog.d/remotelogs.conf.bak
		delete_string
                ;;
        "update")
		cp -pf /etc/rsyslog.d/remotelogs.conf /etc/rsyslog.d/remotelogs.conf.bak
                update_string
                ;;
        *)
                echo "Invalid argument passed. Please check the usage"
                usage
                ;;
  esac
fi




