#!/usr/bin/env python

import sys
import syslog
import subprocess
import os
import re
import signal
import time
from six.moves      import configparser
from datetime       import datetime
#from subprocess import check_output
from signal import signal, SIGINT
from utilDaemon     import UtilDaemon

conf_file = "/etc/opt/avpualarm.conf"

exitFlag = False

# syslog configuration
syslog.openlog('loginmon', syslog.LOG_CONS, syslog.LOG_LOCAL5)

system_pid = "/etc/opt/service.pid"

#
class ServiceMonitor(UtilDaemon):
	"""
	This class is a service monitor daemon process.
	
	Usage: create subclass of UtilDaemon class and override the run() method
	"""
	def __init__(self, pidfile, pidname="ServiceMonitor", stdin='/dev/null', stdout='/dev/null', stderr='/dev/null'):
		self.stdin = stdin
		self.stdout = stdout
		self.stderr = stderr
		self.pidfile = pidfile
		self.pidname = pidname
		#print ("Initializing service monitoring ... ")


	def handler(self,signal_received, frame):
		exitFlag = True


	def run(self):
		#print ("Starting service monitoring ... ")
		service_map = {}
		global exitFlag
		if(os.path.exists(conf_file)):
			parser = configparser.ConfigParser()
			try:
				if(os.path.exists(conf_file)):
					parser.read(conf_file)
					services = parser.get('monitor_service','service_names')
			except OSError, e:
				sys.stderr.write("Error in parsing conf file: %d (%s)\n" % (e.errno, e.strerror))

			if (len(services) == 0):
				print("Services for monitoring are not configured. Exiting... ")
				exit(0)
			else:
				services_list = services.replace(' ','').split(',')
				#print("Service monitoring configured for :%s"%services_list)
				for service_name in services_list:
					(service_status,command_status) = subprocess.Popen(["systemctl list-unit-files | grep "+service_name ] , stdout=subprocess.PIPE, shell=True ).communicate()
					try: 
						find = re.match(r'(.*service) (.*)',service_status.rstrip(),re.M|re.I)
						name = find.group(1)
						status = find.group(2).replace(' ','')
						service_map[name] = status   ## store initial status
					except:
						#print (service_name +" service not found!!!")
						continue
					if (status != "enabled"): ##Alarm for the 1st time if service is not enabled
						if (service_name == "auditd" ):
							syslog.syslog(syslog.LOG_ALERT, "AUDIT_FAULT " + '" {} status is {}"'.format(name,status))
						else:
							syslog.syslog(syslog.LOG_ALERT, "SERVICE_FAULT " + '" Mandatory service {} status is {}"'.format(name,status))

			#print ("Starting service monitoring ... for (%s)"%(service_map.keys()))
			while not exitFlag:
				time.sleep(6)
				for service in service_map.keys():
					rc = os.system("systemctl is-active --quiet "+service)
					if (rc == 0) :  ##service is healthy or restored
						if (service_map[service] != "enabled"): ## Clear alarm if service restored
							if (service == "auditd.service" ):
								syslog.syslog(syslog.LOG_ALERT, "AUDIT_CLEAR " + '" {} status is active"'.format(service))
							else: 
								syslog.syslog(syslog.LOG_ALERT, "SERVICE_CLEAR " + '" Mandatory service {} is active"'.format(service))
							service_map[service] = 'enabled'

					elif (service_map[service] == "enabled"):  ##Need to send failure alarm
						if (service == "auditd.service" ):
							syslog.syslog(syslog.LOG_ALERT, "AUDIT_FAULT " + '" {} status is inactive"'.format(service))
						else:
							syslog.syslog(syslog.LOG_ALERT, "SERVICE_FAULT " + '" Mandatory service {} is inactive"'.format(service))
						service_map[service] = 'inactive' ##mark the Alarm is already sent 


def main():
        # Create Object of Service Monitor class
        ServiceMonitor_d = ServiceMonitor(system_pid, "ServiceMonitor")
        if len(sys.argv) == 2:
           if 'start' == sys.argv[1]:
              # start the Service Monitor daemon but first check if it is alreadry running
              if os.path.exists(system_pid):
                 print "Unable to start Service Monitor service, it is already running, please stop and retry"
              else:
                 print "Service Monitor service is starting"
                 ServiceMonitor_d.run()
           elif 'stop' == sys.argv[1]:
              # stop the daemon
              if os.path.exists(system_pid):
                 print "Stopping System Monitor service"
                 ServiceMonitor_d.stop()
              else:
                 print "Unable to stop Service Monitor service, it is not running"
           elif 'restart' == sys.argv[1]:
              # restart the daemon
              print "Restarting Service Monitor service"
              ServiceMonitor_d.restart()
           elif 'status' == sys.argv[1]:
              # status of daemon
              status2 = ServiceMonitor_d.status()
              if status2:
                 print "Service Monitor service is running"
              else:
                 print "Service Monitor service is not running"
	   elif 'auditd_enable' == sys.argv[1]:
		 syslog.syslog(syslog.LOG_ALERT, "AUDIT_CLEAR "+ '"auditd.service is enabled by admin user"')
	   elif 'auditd_disable' == sys.argv[1]:
		 syslog.syslog(syslog.LOG_ALERT, "AUDIT_FAULT "+ '"auditd.service is disabled by admin user"')
           else:
              print "Unknown command"
              sys.exit(2)
           sys.exit(0)
        else:
                print "usage: %s start|stop|restart" % sys.argv[0]
                sys.exit(2)


if __name__ == "__main__":
        main()


