#!/usr/bin/env python
#
# This process start's/stop's AVPUTIL daemon's
#  example - python system_monitor start
#   1) Currently, it has call to class AuthMonitor which currently monitors 
#      authentication and continously read /var/log/secure using FileTail class.
#   2) It generates alarm in syslog if number of failed attempts exceed
#      failed_login_count in interval failed_login_duration. Both parameters
#      defined in /etc/opt/avpualarm.conf
#   3) If the file is changed this service needs to be restarted to 
#      reflect new changes. 
#
#  version-1 - AVPUTIL-886

import sys
import os

# Below modules are custom modules defined in AVPU.
from authMonitor import AuthMonitor
from serviceMonitor import ServiceMonitor

# pid file to monitor status of daemon
pid_file = "/etc/opt/system_monitor.pid"
system_pid = "/etc/opt/service.pid"

def main():
        # Create Object of AuthMonitor class
        AuthMonitor_d = AuthMonitor(pid_file, "AuthMonitor")
	ServiceMonitor_d = ServiceMonitor(system_pid, "ServiceMonitor")
        if len(sys.argv) == 2:
           if 'start' == sys.argv[1]:
              # start the daemon but first check if it is alreadry running
              if os.path.exists(pid_file):
                 print "Unable to start System Monitor service, it is already running, please stop and retry"
              else:
                 print "System Monitor service is starting"
                 AuthMonitor_d.start()
		 ServiceMonitor_d.start()
           elif 'stop' == sys.argv[1]:
              # stop the daemon
              if os.path.exists(pid_file):
                 print "Stopping System Monitor service"
                 AuthMonitor_d.stop()
		 ServiceMonitor_d.stop()
              else:
                 print "Unable to stop System Monitor service, it is not running"
           elif 'restart' == sys.argv[1]:
              # restart the daemon
              print "Restarting System Monitor service"
              AuthMonitor_d.restart()
	      ServiceMonitor_d.restart()
           elif 'status' == sys.argv[1]:
              # status of daemon
              status1 = AuthMonitor_d.status()
	      status2 = ServiceMonitor_d.status()
              if status1 and status2:
                 print "System Monitor service is running"
              else:
                 print "System Monitor service is not running"
           else:
              print "Unknown command"
              sys.exit(2)
           sys.exit(0)
        else:
                print "usage: %s start|stop|restart" % sys.argv[0]
                sys.exit(2)

               
if __name__ == "__main__":
        main()

