#!/bin/bash

# 
# Executes TMClient actions.
#

COMMON_HOME=/opt/util
TM_HOME=/opt/avaya/tm
LIB_PATH=$COMMON_HOME/lib

source $COMMON_HOME/bin/tm/TMEnv.sh

# the key is cached for performance reasons 
if [ "$1" = "getKey" ] && [ -s $TM_HOME/.key ]
then
	cat $TM_HOME/.key
	exit 0
fi

# JAVA_OPTS can be set outside of this script
JAVA_OPTS="$JAVA_OPTS -Dlog4j.configuration=$TM_LOG4J"
JAVA_OPTS="$JAVA_OPTS -Dorg.bouncycastle.rsa.allow_multi_use=true"

if [ "$1" = "getKey" ] 
then
	# cache the key so access will be faster on slower machines like
	# BSMs
	java $JAVA_OPTS -classpath "$TM_CLASSPATH" \
		com.avaya.asm.mgmt.tmcli.TMClient "$@" > $TM_HOME/.key
	chmod 600 $TM_HOME/.key

	cat $TM_HOME/.key
else
	java $JAVA_OPTS -classpath "$TM_CLASSPATH" \
		com.avaya.asm.mgmt.tmcli.TMClient "$@"
fi
