#!/bin/bash

#
# Set up the environment for TM related scripts
#
# Variables:
#	TM_CLASSPATH
#	TM_LOG4J
#

COMMON_HOME=/opt/util
TM_LOG4J="file:///$COMMON_HOME/bin/tm/tmclient-log4j.xml"

# Dynamically build the classpat so version changes don't cause a problem
JARS='
log4j
jboss-trust-logging
avaya_logging_client
tmclient
TMInvUpgrade
tmcrdparser
xbean
ejbca-ejb
commons-lang
commons-codec
common-utils
asm-common
asmmgmt_trust_cli
avaya-periodic-retention-logging
'

for JAR_NAME in $JARS
do
        JAR=$(ls $COMMON_HOME/lib/$JAR_NAME* 2> /dev/null | tail -1)
        [ "$JAR" = "" ] && continue
        TM_CLASSPATH=$JAR:$TM_CLASSPATH
done

# remove trailing ':'
TM_CLASSPATH=$(echo $TM_CLASSPATH | sed 's/:$//')

unset JARS JAR_NAME
