#!/bin/bash

#############################################################################
#
# Copyright Avaya Inc., All Rights Reserved.
#
# THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
#
# The copyright notice above does not evidence any actual or intended
# publication of such source code.
#
# Some third-party source code components may have  been modified from their
# original versions by Avaya Inc.
#
# The modifications are Copyright Avaya Inc., All Rights Reserved.
#
# Avaya - Confidential & Restricted. May not be distributed further without
# written permission of the Avaya owner.
#
#############################################################################

#############################################################################
# Re-Issues any certificates that contain the old FQND (passed in).  Only
# certs signed by System Manager and contain the old FQDN will be updated 
# with the new FQDN (passed in).
#
# The environment variable SCEPPassword needs to be set for this method to
# work correctly.
#
# Usage: TMReIssueCerts.sh <old FQDN> <new FQDN>
#############################################################################

COMMON_HOME=/opt/util

source /opt/avaya/common_services/install.properties
source $COMMON_HOME/bin/tm/TMEnv.sh

if [ -z "$SCEPPassword" ]
then
	echo "Enrollment password is not set!"
	exit 1
fi

java -Dlog4j.configuration=$TM_LOG4J \
	-Dorg.bouncycastle.rsa.allow_multi_use=true -classpath "$TM_CLASSPATH" \
	com.avaya.asm.mgmt.tmcli.TMReIssueCerts $SmgrIP "$@"
exit $?
