#!/bin/bash
# Wrapper script to use openssl for calculating the hash for a CRL file
#
# Supports CRL file in PEM format only

if [ "$#" -ne 1 ]
then
	echo "usage: $0 <CRL file path>"
	exit 1
fi

crlFile=$1
if [ -e $crlFile ]
then
	/usr/bin/openssl crl -in $crlFile -hash -noout
else
	echo "CRL file $crlFile not found"
	exit 1
fi
