#!/bin/bash

#
# Script that handles the restoring of certificates.  
# 
# NOTE: Previously this script also handled upgrades but now
# it is purely for backup and restore.  Upgrades from previous
# releases are now done in upgrade_certs.sh.
#

source /opt/avaya/common_services/install.properties
source /opt/util/bin/tm/TMEnv.sh

COMMON_HOME=/opt/util
TMPATH=/opt/avaya/tm
SPIRIT_TMPATH=/opt/spirit/security
TMCLIENT=$COMMON_HOME/bin/TMClient.sh

# backup directory should be passed in, otherwise default to an upgrade
BACKUPDIR=$1
: ${BACKUPDIR:="/opt/Avaya/upgrade"}

if [ ! -d $BACKUPDIR ]
then
    echo "Backup directory ($BACKUPDIR} does not exist"
    exit 1
fi

# Remove any previous certificates
rm -f $TMPATH/TMClientInv.xml
rm -f $TMPATH/EncryptionKeyFile
rm -rf $TMPATH/keystore
rm -rf $TMPATH/truststore

# Restore all of the certificate and TM files
cp $BACKUPDIR/$TMPATH/TMClientInv.xml $TMPATH
cp -rL $BACKUPDIR/$TMPATH/keystore $TMPATH
cp -rL $BACKUPDIR/$TMPATH/truststore $TMPATH
if [ -f $BACKUPDIR/$TMPATH/EncryptionKeyFile ]
then
	cp $BACKUPDIR/$TMPATH/EncryptionKeyFile $TMPATH
fi
 
if [ ! -f $TMPATH/EncryptionKeyFile ]
then 
	# must be an older TMClientInv.xml file that needs to be upgraded
	echo "Upgrading TMClientInv.xml"
	java -cp "$TM_CLASSPATH" TMInvUpgrade $TMPATH &> /dev/null
fi

# Convert any jks files to bcfks (7.1+)
$TMCLIENT convertKeystoresToBCFKS


# make sure the copied files have the correct permissions
chown -R java:root $TMPATH

exit 0

# vim: softtabstop=4 shiftwidth=4 expandtab
