#!/bin/bash

#
# Script that configures trust management settings. 
#
source /opt/avaya/common_services/install.properties

COMMON_HOME=/opt/util
TM_HOME=/opt/avaya/tm/
TMCLIENT=$COMMON_HOME/bin/TMClient.sh
JAVA_CMD=/usr/java/latest/bin/java

source $COMMON_HOME/bin/tm/TMEnv.sh

# Setup JARs for DRS
#DRS_CP=$DRS_HOME/lib/drs-utils.jar:$DRS_HOME/lib/pan_securestore.jar

JVM_OPT="-Dlog4j.configuration=$TM_LOG4J"

$JAVA_CMD $JVM_OPT -classpath $TM_CLASSPATH com.avaya.asm.mgmt.tmcli.TMSetup

# setup trust.properties
sed -i "s/@SMGR_IP/$SmgrIP/" $TM_HOME/trust.properties

