#!/bin/sh
# **************************************************************************
# *
# * Copyright Avaya Inc., All Rights Reserved.
# *
# * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
# *
# * The copyright notice above does not evidence any actual or intended
# * publication of such source code.
# *
# * Some third-party source code components may have  been modified from their
# * original versions by Avaya Inc.
# *
# * The modifications are Copyright Avaya Inc., All Rights Reserved.
# *
# * Avaya - Confidential & Restricted. May not be distributed further without
# * written permission of the Avaya owner.
# *
# *****************************************************************************/

TM_SERVICE_JAR=/opt/util/lib/trust-client-service.jar
TM_JAR=/opt/util/lib
CONF=/opt/util/conf
JAVA_CMD=/usr/java/latest/bin/java
LOGS=/var/log/trust_client_service_debug.log

function usage(){
    echo ""
    echo " usage:  $(basename $0) [start | stop | status]"
    echo ""
    exit 1
}

function start(){
#first check status of the service
status
is_running=$?
if [ $is_running -eq 1 ]; then
    exit 1
else
    echo "Starting the trust-client-service..."  | tee -a $LOGS
    $JAVA_CMD -cp "$TM_SERVICE_JAR:$TM_JAR/*:$CONF" com.avaya.mgmt.trust.tmclient.jboss.Main >> $LOGS 2>&1 &
fi
}

function status(){
ps -aux | grep com.avaya.mgmt.trust.tmclient.jboss.Main | grep -q java 
if [ $? -eq 0 ]; then
    echo "Trust-Client service is running..."  | tee -a $LOGS
    return 1
else
    echo "Trust-Client service is not running..."  | tee -a $LOGS
    return 2
fi
}

function stop(){
status
is_running=$?
if [ $is_running -eq 2 ]; then
    exit 1
else
    echo "Stopping trust-client-service..."  | tee -a $LOGS
    ps -aux | grep com.avaya.mgmt.trust.tmclient.jboss.Main | grep java |  awk '{print $2}' | xargs kill -9
    if [ $? -eq 0 ]; then
        echo "Service has been stopped successfully"  | tee -a $LOGS
    else
        echo "Trust-client-service stop failed"  | tee -a $LOGS
        exit 1
    fi
fi
}

if [[ "$1" == "start" ]]; then
  start
elif [[ "$1" == "stop" ]]; then
  stop
elif [[ "$1" == "status" ]]; then
  status
else
  usage
fi
