#!/bin/bash
# vim:ts=4:sw=4
#############################################################################
#
# Copyright Avaya Inc., All Rights Reserved.
#
# THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
#
# The copyright notice above does not evidence any actual or intended
# publication of such source code.
#
# Some third-party source code components may have  been modified from their
# original versions by Avaya Inc.
#
# The modifications are Copyright Avaya Inc., All Rights Reserved.
#
# Avaya - Confidential & Restricted. May not be distributed further without
# written permission of the Avaya owner.
#
#############################################################################

#############################################################################
# Script that copies the syslog certificates from Trust Management 
# to syslog directory.
#############################################################################

TMPATH=/opt/avaya/tm

LDAP_TMPATH_ROOT=/etc/pki/tls
LDAP_TRUSTSTORE_PATH=$LDAP_TMPATH_ROOT
USER=root


function usage(){
    echo ""
    echo " usage:  $(basename $0) "
    echo ""
    echo
    exit 1
}

logger "Updating ldap certificate"

if [ -e $TMPATH/truststore/ldap_truststore.pem ]
then
   if [ -f $LDAP_TRUSTSTORE_PATH/ca_ldap.pem ]; then
        echo "Link is already created"
   else
        ln -s $TMPATH/truststore/ldap_truststore.pem $LDAP_TRUSTSTORE_PATH
   fi
fi

exit 0
