#!/bin/bash

#############################################################################
#
# Copyright Avaya Inc., All Rights Reserved.
#
# THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
#
# The copyright notice above does not evidence any actual or intended
# publication of such source code.
#
# Some third-party source code components may have  been modified from their
# original versions by Avaya Inc.
#
# The modifications are Copyright Avaya Inc., All Rights Reserved.
#
# Avaya - Confidential & Restricted. May not be distributed further without
# written permission of the Avaya owner.
#
#############################################################################

#############################################################################
# Script that copies the Spirit certificates from Trust Management 
# to Spirit directory.
#############################################################################

SPIRIT_HOME=/opt/spirit
SECURITY_PROPS=$SPIRIT_HOME/security/spirit_security.properties
TMPATH=/opt/avaya/tm

function usage(){
	echo ""
	echo " usage:  $(basename $0) [-r]"
	echo ""
	echo "         -r - restart sal-agent"
	echo
	exit 1
}

while getopts "r" OPTION
do
    case "${OPTION}" in
		r) 
			RESTART=1
			;;
			
		[?])
			usage
			;;
	esac
done

logger "Updating sal-agent certificates"

# see if the spirit user exists
id java &>/dev/null
if [ $? = 0 ]
then
	USER=java

	# need to allow the spirit user access to the TM directory
	setfacl -m u:$USER:rx /opt/avaya/tm

	# needs to be writable for the TMClientInv lock file
	setfacl -m u:$USER:rwx $TMPATH

	setfacl -m u:$USER:r $TMPATH/TMClientInv.xml
	setfacl -m u:$USER:r $TMPATH/trust.properties
	setfacl -m u:$USER:r $TMPATH/EncryptionKeyFile
	setfacl -m u:$USER:rx $TMPATH/revocation
	setfacl -m u:$USER:rx $TMPATH/revocation/crl
else
	USER=root
fi

if [ -e $TMPATH/truststore/spirit-trust.bcfks ]
then
   if [ -f $SPIRIT_HOME/security/spirit-trust.bcfks ]; then
        echo "Link is already created"
   else
        ln -s $TMPATH/truststore/spirit-trust.bcfks $SPIRIT_HOME/security/
   fi
fi

if [ -e $TMPATH/keystore/spirit-identity.bcfks ]
then
   if [ -f $SPIRIT_HOME/security/spirit-identity.bcfks ]; then
        echo "Link is already created"
   else
        ln -s $TMPATH/keystore/spirit-identity.bcfks $SPIRIT_HOME/security/
   fi
fi

# Assure that files in this directory are only readable by user spirit
chmod -R go-rwx $SPIRIT_HOME/security

# Configure spirit to use the bcfks files
if grep -q "/opt/spirit/security/identity.jks" $SECURITY_PROPS; then
  sed -i 's/trust.jks/spirit-trust.bcfks/g' $SECURITY_PROPS
  sed -i 's/identity.jks/spirit-identity.bcfks/g' $SECURITY_PROPS
else
  sed -i 's/spirit-trust.jks/spirit-trust.bcfks/g' $SECURITY_PROPS 
  sed -i 's/spirit-identity.jks/spirit-identity.bcfks/g' $SECURITY_PROPS
fi
sed -i 's/JKS/BCFKS/' $SECURITY_PROPS

# configure spirit to use TM for the password
CLASS='{CLASS}com.avaya.mgmt.trust.util.TMPasswordJboss:spiritalias'
sed -i "s|\(.*identityKeyStorePasswordEncrypted\).*|\1=$CLASS,$TMPATH,KS|" \
	$SECURITY_PROPS
sed -i "s|\(.*keyStorePasswordEncrypted\).*|\1=$CLASS,$TMPATH,TS|" \
	$SECURITY_PROPS

if [ $RESTART ]
then
	logger "Restarting sal-agent due to certificate change"
	service spiritAgent restart
fi

exit 0
