#!/bin/bash
# vim:ts=4:sw=4
#############################################################################
#
# Copyright Avaya Inc., All Rights Reserved.
#
# THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
#
# The copyright notice above does not evidence any actual or intended
# publication of such source code.
#
# Some third-party source code components may have  been modified from their
# original versions by Avaya Inc.
#
# The modifications are Copyright Avaya Inc., All Rights Reserved.
#
# Avaya - Confidential & Restricted. May not be distributed further without
# written permission of the Avaya owner.
#
#############################################################################

#############################################################################
# Script that copies the syslog certificates from Trust Management 
# to syslog directory.
#############################################################################

TMPATH=/opt/avaya/tm

SYSLOG_TMPATH_ROOT=/etc/pki/rsyslog
SYSLOG_TRUSTSTORE_PATH=$SYSLOG_TMPATH_ROOT
SYSLOG_KEYSTORE_PATH=$SYSLOG_TMPATH_ROOT
USER=root


function usage(){
    echo ""
    echo " usage:  $(basename $0) [-r]"
    echo ""
    echo "         -r - restart syslog"
    echo
    exit 1
}

while getopts "r" OPTION
do
    case "${OPTION}" in
        r) 
            RESTART=1
            ;;
            
        [?])
            usage
            ;;
    esac
done

logger "Updating syslog certificates"

mkdir -p $SYSLOG_TRUSTSTORE_PATH $SYSLOG_KEYSTORE_PATH
chown -R $USER:$USER $SYSLOG_TMPATH_ROOT
chmod -R 700 $SYSLOG_TMPATH_ROOT

if [ -e $TMPATH/truststore/syslog_truststore.pem ]
then
   if [ -f $SYSLOG_TRUSTSTORE_PATH/syslog_truststore.pem ]; then
        echo "Link is already created"
   else
        ln -s $TMPATH/truststore/syslog_truststore.pem $SYSLOG_TRUSTSTORE_PATH
   fi
fi

if [ -e $TMPATH/keystore/syslog_keystore.pem ]
then
   if [ -f $SYSLOG_TRUSTSTORE_PATH/syslog_keystore.pem ]; then
        echo "Link is already created"
   else 
        ln -s $TMPATH/keystore/syslog_keystore.pem $SYSLOG_KEYSTORE_PATH
   fi
fi

if [ $RESTART ]
then
    # restart syslog so that the new certificates are used.
    logger "Restarting rsyslog due to certificate change"
    service rsyslogd restart &> /dev/null
fi

exit 0
