#!/usr/bin/env python

import sys
import os
import time
import atexit
import syslog

from signal import SIGTERM 

# syslog configuration
syslog.openlog('loginmon', syslog.LOG_CONS, syslog.LOG_SYSLOG)

class UtilDaemon:
	"""
	This class is a generic class to create a daemon process.
	
	Usage: create subclass of UtilDaemon class and override the run() method
	"""
	def __init__(self, pidfile, pidname="UtilDaemon", stdin='/dev/null', stdout='/dev/null', stderr='/dev/null'):
		self.stdin = stdin
		self.stdout = stdout
		self.stderr = stderr
		self.pidfile = pidfile
                self.pidname = pidname
	
	def daemonize(self):
		"""
		Do double-fork first one to detach from calling process, then setsid() is 
                called to make it session leader and then for second time.
		"""
		try: 
			pid = os.fork() 
			if pid > 0:
				# exit first parent
				sys.exit(0) 
		except OSError, e: 
			sys.stderr.write("UtilDaemon failed to fork 1: %d (%s)\n" % (e.errno, e.strerror))
			sys.exit(1)
	
		# decouple from parent environment
		os.chdir("/") 
		os.setsid() 
		os.umask(0) 
	
		# do second fork
		try: 
			pid = os.fork() 
			if pid > 0:
				# exit from second parent
				sys.exit(0) 
		except OSError, e: 
			sys.stderr.write("UtilDaemon failed to fork 2: %d (%s)\n" % (e.errno, e.strerror))
			sys.exit(1) 
	
		# redirect standard file descriptors
		sys.stdout.flush()
		sys.stderr.flush()
		si = file(self.stdin, 'r')
		so = file(self.stdout, 'a+')
		se = file(self.stderr, 'a+', 0)
		os.dup2(si.fileno(), sys.stdin.fileno())
		os.dup2(so.fileno(), sys.stdout.fileno())
		os.dup2(se.fileno(), sys.stderr.fileno())
	
		# write pidfile
		atexit.register(self.delpid)
		pid = str(os.getpid())
		file(self.pidfile,'w+').write("%s\n" % pid)
	
	def delpid(self):
		os.remove(self.pidfile)

	def start(self):
		"""
		Start the daemon
		"""
		# Check for a pidfile to see if the daemon is already running
		try:
			pf = file(self.pidfile,'r')
			pid = int(pf.read().strip())
			pf.close()
		except IOError:
			pid = None
	
		if pid:
			message = "UtilDaemon already running\n"
			sys.stderr.write(message)
			sys.exit(1)
		
		# Start the daemon
		self.daemonize()
                syslog.syslog(syslog.LOG_NOTICE, 'Daemon started ' + self.pidname)
		self.run()

	def stop(self, restart=False):
		"""
		Stop the daemon
		"""
		# Get the pid from the pidfile
		try:
			pf = file(self.pidfile,'r')
			pid = int(pf.read().strip())
			pf.close()
		except IOError:
			pid = None
	
		if not pid:
                        if not restart:
			   message = "UtilDaemon does not exist.\n"
			   sys.stderr.write(message)
			return # not an error in a restart

		# Try killing the daemon process	
		try:
                        syslog.syslog(syslog.LOG_NOTICE, 'Daemon stopped ' + self.pidname)
                        while 1:
			        os.kill(pid, SIGTERM)
			        time.sleep(0.1)
		except OSError, err:
			err = str(err)
			if err.find("No such process") > 0:
				if os.path.exists(self.pidfile):
					os.remove(self.pidfile)
			else:
				print str(err)
				sys.exit(1)

	def restart(self):
		"""
		Restart the UtilDaemon
		"""
                rc = False
		self.stop(True)
		rc = self.start()
                return rc

        def status(self):
                """
                Status of the daemon
                """
                try:
                        pf = file(self.pidfile,'r')
                        pid = int(pf.read().strip())
                        pf.close()
                except IOError:
                        pid = None

                if not pid:
                        return False # not an error in a restart
                else:
                        return True

	def run(self):
		"""
		Always Override this method when you subclass Daemon. It will be called after the process has been
		daemonized by start() or restart().
		"""

