/*
 * Decompiled with CFR 0.152.
 */
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.StringTokenizer;
import java.util.Vector;

public class ConfigReader {
    public static Vector allParameters = new Vector();
    public static Vector allTexts = new Vector();
    public static int language = 0;
    private String config_file_name;

    public ConfigReader(String string) {
        this.config_file_name = new String(string);
        this.readLanguageText();
    }

    private void readLanguageText() {
        Object object;
        LineNumberReader lineNumberReader;
        FileReader fileReader = null;
        try {
            fileReader = new FileReader("config/language.csv");
            lineNumberReader = new LineNumberReader(fileReader);
        }
        catch (FileNotFoundException fileNotFoundException) {
            object = this.getClass().getResourceAsStream("config/language.csv");
            lineNumberReader = new LineNumberReader(new InputStreamReader((InputStream)object));
        }
        try {
            int n = 0;
            while (lineNumberReader.ready()) {
                StringTokenizer stringTokenizer = new StringTokenizer(lineNumberReader.readLine(), ";");
                object = stringTokenizer.nextToken();
                if (stringTokenizer.hasMoreTokens()) {
                    int n2 = stringTokenizer.countTokens();
                    for (int i = 1; i <= n2; ++i) {
                        String string = stringTokenizer.nextToken();
                        LanguageText languageText = new LanguageText((String)object, i, string);
                        allTexts.add(languageText);
                    }
                }
                ++n;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public Vector getLanguages() {
        Vector<String> vector = new Vector<String>();
        boolean bl = true;
        int n = 0;
        while (bl) {
            LanguageText languageText = (LanguageText)allTexts.elementAt(n);
            while (languageText.isSysText("language")) {
                bl = false;
                vector.add(languageText.getText());
                languageText = (LanguageText)allTexts.elementAt(++n);
            }
            ++n;
        }
        return vector;
    }

    public void readConfigFile() {
        Object object;
        LineNumberReader lineNumberReader;
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(this.config_file_name);
            lineNumberReader = new LineNumberReader(fileReader);
        }
        catch (FileNotFoundException fileNotFoundException) {
            object = this.getClass().getResourceAsStream(this.config_file_name);
            lineNumberReader = new LineNumberReader(new InputStreamReader((InputStream)object));
        }
        try {
            String string = "";
            while (lineNumberReader.ready()) {
                object = new ConfigRow();
                StringTokenizer stringTokenizer = new StringTokenizer(lineNumberReader.readLine(), ",");
                if (stringTokenizer.hasMoreTokens()) {
                    StringTokenizer stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken(), "\"");
                    stringTokenizer2.nextToken();
                    ((ConfigRow)object).setName(stringTokenizer2.nextToken());
                    if (stringTokenizer.hasMoreTokens()) {
                        string = new String(stringTokenizer.nextToken());
                    }
                    if (string.indexOf(new String("OPTION_MUST")) >= 0) {
                        ((ConfigRow)object).setRequired(true);
                    }
                    if (string.indexOf(new String("OPTION_LIST")) >= 0) {
                        ((ConfigRow)object).setList(true);
                    }
                    if (string.indexOf(new String("OPTION_BOOL")) >= 0) {
                        ((ConfigRow)object).setType(1);
                    } else if (string.indexOf(new String("OPTION_STRING")) >= 0) {
                        ((ConfigRow)object).setType(2);
                    } else if (string.indexOf(new String("OPTION_IP")) >= 0) {
                        ((ConfigRow)object).setType(3);
                    } else if (string.indexOf(new String("OPTION_U8")) >= 0) {
                        ((ConfigRow)object).setType(4);
                    } else if (string.indexOf(new String("OPTION_U16")) >= 0) {
                        ((ConfigRow)object).setType(5);
                    }
                }
                allParameters.add(object);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static int getIndexFromConfig(String string) {
        int n = -1;
        for (int i = 0; i < allParameters.size(); ++i) {
            ConfigRow configRow = (ConfigRow)allParameters.elementAt(i);
            if (!configRow.getName().equals(string)) continue;
            n = i;
        }
        return n;
    }

    public static String getCurrentLang(String string) {
        for (int i = 0; i < allTexts.size(); ++i) {
            LanguageText languageText = (LanguageText)allTexts.elementAt(i);
            if (!languageText.isSysText(string) || !languageText.isLanguage(language)) continue;
            return languageText.getText();
        }
        return string;
    }
}

