/*
 * Decompiled with CFR 0.152.
 */
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ListPanel
extends JPanel
implements ActionListener {
    private JLabel description;
    private JList valuelist;
    private JFrame main_frame;
    private JButton listedit;
    private JButton listdel;
    private String name;
    private ParamPanel param_pnl;
    private static final long serialVersionUID = 7526472295622776147L;

    public ListPanel(JFrame jFrame, ConfigRow configRow, int n, Vector vector, boolean bl, ParamPanel paramPanel) {
        this.description = new JLabel("  " + configRow.getLanguageText());
        DefaultListModel defaultListModel = new DefaultListModel();
        this.valuelist = new JList(defaultListModel);
        DataObj dataObj = new DataObj(this.description, configRow.getName(), this.valuelist, configRow.isRequired());
        dataObj.setConfigRowRef(n);
        DataObj.config_data.add(dataObj);
        this.create(jFrame, dataObj, n, vector, bl, paramPanel);
    }

    public ListPanel(JFrame jFrame, DataObj dataObj, int n, Vector vector, boolean bl, ParamPanel paramPanel) {
        this.create(jFrame, dataObj, n, vector, bl, paramPanel);
    }

    private void create(JFrame jFrame, DataObj dataObj, int n, Vector vector, boolean bl, ParamPanel paramPanel) {
        this.main_frame = jFrame;
        this.name = dataObj.getName();
        this.param_pnl = paramPanel;
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        this.setBorder(BorderFactory.createEtchedBorder(1));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 2, 0, 0));
        jPanel.add(this.description);
        ListSelectionListener listSelectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (ListPanel.this.valuelist.isSelectionEmpty()) {
                    ListPanel.this.listedit.setEnabled(false);
                    ListPanel.this.listdel.setEnabled(false);
                } else {
                    ListPanel.this.listedit.setEnabled(true);
                    ListPanel.this.listdel.setEnabled(true);
                }
            }
        };
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(gridBagLayout2);
        JScrollPane jScrollPane = new JScrollPane();
        this.valuelist.addListSelectionListener(listSelectionListener);
        gridBagLayout2.setConstraints(jScrollPane, this.setAllConstraints(0, 0, 3, 2, 0.0, 0.0));
        jScrollPane.setViewportView(this.valuelist);
        jPanel2.add(jScrollPane);
        URL uRL = ListPanel.class.getResource("images/add.png");
        JButton jButton = new JButton(new ImageIcon(uRL));
        jButton.setActionCommand("listadd");
        jButton.addActionListener(this);
        gridBagLayout2.setConstraints(jButton, this.setAllConstraints(0, 2, 1, 1, 1.0, 0.0));
        jPanel2.add(jButton);
        URL uRL2 = ListPanel.class.getResource("images/data_edit.png");
        this.listedit = new JButton(new ImageIcon(uRL2));
        this.listedit.setEnabled(false);
        this.listedit.setActionCommand("listedit");
        this.listedit.addActionListener(this);
        gridBagLayout2.setConstraints(this.listedit, this.setAllConstraints(1, 2, 1, 1, 1.0, 0.0));
        jPanel2.add(this.listedit);
        URL uRL3 = ListPanel.class.getResource("images/delete.png");
        this.listdel = new JButton(new ImageIcon(uRL3));
        this.listdel.setEnabled(false);
        this.listdel.setActionCommand("listdel");
        this.listdel.addActionListener(this);
        gridBagLayout2.setConstraints(this.listdel, this.setAllConstraints(2, 2, 1, 1, 1.0, 0.0));
        jPanel2.add(this.listdel);
        jPanel.add(jPanel2);
        gridBagLayout.setConstraints(jPanel, this.setAllConstraints(0, 0, 1, 2, 1.0, 0.0));
        this.add(jPanel);
        URL uRL4 = ListPanel.class.getResource("images/pnl_delete.png");
        JButton jButton2 = new JButton(new ImageIcon(uRL4));
        jButton2.setEnabled(bl);
        jButton2.setActionCommand("paradel");
        jButton2.addActionListener(this);
        gridBagLayout.setConstraints(jButton2, this.setAllConstraints(2, 0, 1, 1, 0.0, 0.0));
        this.add(jButton2);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("listadd")) {
            ListAddDlg listAddDlg = new ListAddDlg(this.main_frame, this.valuelist);
            listAddDlg.show();
        } else if (actionEvent.getActionCommand().equals("listedit")) {
            ListEditDlg listEditDlg = new ListEditDlg(this.main_frame, this.valuelist);
            listEditDlg.show();
        } else if (actionEvent.getActionCommand().equals("listdel")) {
            ListDelDlg listDelDlg = new ListDelDlg(this.main_frame, this.valuelist);
            listDelDlg.show();
        } else if (actionEvent.getActionCommand().equals("paradel")) {
            this.param_pnl.removeParameter(this.name);
        }
    }

    private GridBagConstraints setAllConstraints(int n, int n2, int n3, int n4, double d, double d2) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = d;
        gridBagConstraints.weighty = d2;
        return gridBagConstraints;
    }
}

