/*
 * Decompiled with CFR 0.152.
 */
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.Timer;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

public class StationPanel
extends JPanel
implements ActionListener {
    private JPanel sub_pnl;
    private JCheckBox ipadrcheck;
    private JLabel tl1;
    private JTextField ipadr;
    private JTextField macadr;
    private ItemListener checkItemListener;
    private JButton listBt;
    private modeFrame main_frame;
    private ActionListener taskPerformer;
    private short num_rfp_packets = 0;
    private NetworkThread n_thread;
    private int net_action;
    private Timer timer;
    private String errorVal;
    private ParamPanel param_pnl;
    private static final long serialVersionUID = 7526472295622776147L;
    public static final int timer_period = 200;

    public StationPanel(modeFrame modeFrame2) {
        this.setLayout(new GridLayout(1, 1));
        this.errorVal = "";
        this.main_frame = modeFrame2;
        this.setBorder(new BevelBorder(0));
        this.checkItemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (StationPanel.this.ipadrcheck.isSelected()) {
                    StationPanel.this.ipadr.setEnabled(true);
                } else {
                    StationPanel.this.ipadr.setEnabled(false);
                }
            }
        };
        this.sub_pnl = new JPanel();
        this.sub_pnl.setLayout(new GridLayout(2, 3, 0, 0));
        Border border = BorderFactory.createEtchedBorder(1);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(border, this.getCurrentLang("rfp_headline"));
        this.sub_pnl.setBorder(titledBorder);
        this.ipadrcheck = new JCheckBox(this.getCurrentLang("rfp_address"));
        this.ipadrcheck.addItemListener(this.checkItemListener);
        this.sub_pnl.add(this.ipadrcheck);
        this.ipadr = new JTextField("", 15);
        this.ipadr.setEnabled(false);
        this.sub_pnl.add(this.ipadr);
        this.sub_pnl.add(new JLabel(""));
        this.tl1 = new JLabel(this.getCurrentLang("mac_address"));
        this.sub_pnl.add(this.tl1);
        this.macadr = new JTextField("", 15);
        this.macadr.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent caretEvent) {
                if (StationPanel.this.testMacAddress()) {
                    StationPanel.this.listBt.setEnabled(true);
                    ((StationPanel)StationPanel.this).main_frame.sendconf.setEnabled(true);
                    ((StationPanel)StationPanel.this).main_frame.conf_send.setEnabled(true);
                } else {
                    StationPanel.this.listBt.setEnabled(false);
                    ((StationPanel)StationPanel.this).main_frame.sendconf.setEnabled(false);
                    ((StationPanel)StationPanel.this).main_frame.conf_send.setEnabled(false);
                }
            }
        });
        this.macadr.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (StationPanel.this.testMacAddress()) {
                    StationPanel.this.listBt.setEnabled(true);
                    ((StationPanel)StationPanel.this).main_frame.sendconf.setEnabled(true);
                    ((StationPanel)StationPanel.this).main_frame.conf_send.setEnabled(true);
                } else {
                    StationPanel.this.listBt.setEnabled(false);
                    ((StationPanel)StationPanel.this).main_frame.sendconf.setEnabled(false);
                    ((StationPanel)StationPanel.this).main_frame.conf_send.setEnabled(false);
                }
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }
        });
        this.sub_pnl.add(this.macadr);
        this.listBt = new JButton("List configuration");
        this.listBt.setActionCommand("LIST_CONF");
        this.listBt.addActionListener(this);
        this.listBt.setEnabled(false);
        this.sub_pnl.add(this.listBt);
        this.add(this.sub_pnl);
        this.taskPerformer = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!StationPanel.this.n_thread.isAlive()) {
                    StationPanel.this.timer.stop();
                    if (StationPanel.this.n_thread.getSendStatus() == 0) {
                        modeFrame.statusbar.Info(StationPanel.this.n_thread.getSendStatusString());
                        if (StationPanel.this.net_action == 2) {
                            StationPanel.this.setListParams(StationPanel.this.n_thread.getParamString());
                        }
                    } else {
                        modeFrame.statusbar.Error(StationPanel.this.n_thread.getSendStatusString() + " !");
                    }
                }
            }
        };
    }

    public void setParamPanel(ParamPanel paramPanel) {
        this.param_pnl = paramPanel;
    }

    private String getCurrentLang(String string) {
        for (int i = 0; i < ConfigReader.allTexts.size(); ++i) {
            LanguageText languageText = (LanguageText)ConfigReader.allTexts.elementAt(i);
            if (!languageText.isSysText(string) || !languageText.isLanguage(ConfigReader.language)) continue;
            return languageText.getText();
        }
        return string;
    }

    public void setTexts() {
        this.ipadrcheck.setText(this.getCurrentLang("rfp_address"));
        this.tl1.setText("  " + this.getCurrentLang("mac_address"));
        this.listBt.setText(this.getCurrentLang("list_conf"));
        Border border = BorderFactory.createEtchedBorder(1);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(border, this.getCurrentLang("rfp_headline"));
        this.sub_pnl.setBorder(titledBorder);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkParam(String string, int n) {
        boolean bl;
        block10: {
            StringTokenizer stringTokenizer;
            block12: {
                block13: {
                    block11: {
                        bl = true;
                        if (n != 3) break block11;
                        stringTokenizer = new StringTokenizer(string, ".");
                        if (stringTokenizer.countTokens() == 4) break block12;
                        bl = false;
                        break block10;
                    }
                    if (n != 4) break block13;
                    int n2 = -1;
                    try {
                        n2 = Integer.valueOf(string);
                        if (n2 < 0 || n2 > 255) {
                            bl = false;
                        }
                        break block10;
                    }
                    catch (NumberFormatException numberFormatException) {
                        bl = false;
                    }
                    break block10;
                }
                if (n != 5) break block10;
                int n3 = -1;
                try {
                    n3 = Integer.valueOf(string);
                    if (n3 < 0 || n3 > 65535) {
                        bl = false;
                    }
                    break block10;
                }
                catch (NumberFormatException numberFormatException) {
                    bl = false;
                }
                break block10;
            }
            while (stringTokenizer.hasMoreTokens()) {
                try {
                    int n4 = Integer.valueOf(stringTokenizer.nextToken());
                    if (n4 >= 0 && n4 <= 255) continue;
                    bl = false;
                }
                catch (NumberFormatException numberFormatException) {
                    bl = false;
                }
            }
        }
        if (!bl && this.errorVal.equals("")) {
            this.errorVal = string;
        }
        return bl;
    }

    private void warnMessage() {
        Object[] objectArray = new Object[]{"OK"};
        String string = "Value '" + this.errorVal + "' is invalid!";
        JOptionPane.showOptionDialog(null, string, "Warning", -1, 2, null, objectArray, objectArray[0]);
    }

    public void ParamSend() {
        block15: {
            Object object;
            boolean bl = false;
            this.errorVal = "";
            ParamPacket paramPacket = new ParamPacket(1);
            String string = new String();
            paramPacket.setDestinationMac(this.macadr.getText());
            for (int i = 0; i < DataObj.config_data.size(); ++i) {
                ConfigRow configRow;
                object = (DataObj)DataObj.config_data.elementAt(i);
                if (((DataObj)object).isBool()) {
                    string = string + new String(((DataObj)object).getName() + "=" + ((DataObj)object).getBoolValue() + "\u0000");
                    continue;
                }
                if (((DataObj)object).isText()) {
                    configRow = (ConfigRow)ConfigReader.allParameters.elementAt(((DataObj)object).getConfigRowRef());
                    if (this.checkParam(((DataObj)object).getText(), configRow.getType())) {
                        string = string + new String(((DataObj)object).getName() + "=" + ((DataObj)object).getText() + "\u0000");
                        continue;
                    }
                    bl = true;
                    continue;
                }
                if (!((DataObj)object).isList()) continue;
                configRow = (ConfigRow)ConfigReader.allParameters.elementAt(((DataObj)object).getConfigRowRef());
                JList jList = ((DataObj)object).getList();
                ListModel listModel = jList.getModel();
                if (listModel.getSize() <= 0) continue;
                string = string + new String(((DataObj)object).getName() + "=");
                for (int j = 0; j < listModel.getSize(); ++j) {
                    if (j < listModel.getSize() - 1) {
                        string = string + listModel.getElementAt(j) + " ";
                        if (this.checkParam(listModel.getElementAt(j).toString(), configRow.getType())) continue;
                        bl = true;
                        continue;
                    }
                    string = string + listModel.getElementAt(j) + "\u0000";
                    if (this.checkParam(listModel.getElementAt(j).toString(), configRow.getType())) continue;
                    bl = true;
                }
            }
            if (!bl) {
                short s = this.num_rfp_packets;
                this.num_rfp_packets = (short)(s + 1);
                paramPacket.setIdent(s);
                paramPacket.setParameter(string);
                object = new byte[]{-1, -1, -1, -1};
                try {
                    InetAddress inetAddress = InetAddress.getByAddress((byte[])object);
                    if (this.ipadrcheck.isSelected()) {
                        try {
                            inetAddress = InetAddress.getByName(this.ipadr.getText());
                        }
                        catch (UnknownHostException unknownHostException) {
                            modeFrame.statusbar.Error("Unknown host: '" + this.ipadr.getText() + "'");
                            return;
                        }
                    }
                    boolean bl2 = !this.ipadrcheck.isSelected();
                    if (this.num_rfp_packets > 1 && this.n_thread.isAlive()) {
                        modeFrame.statusbar.Warning("busy: no list send");
                        break block15;
                    }
                    this.n_thread = new NetworkThread(modeFrame.debugEnabled());
                    this.n_thread.setSendParam(inetAddress, paramPacket, bl2);
                    this.n_thread.start();
                    this.net_action = 1;
                    if (this.timer == null) {
                        this.timer = new Timer(200, this.taskPerformer);
                    }
                    this.timer.start();
                    modeFrame.statusbar.Info("send config command to \"" + this.macadr.getText() + "\"");
                }
                catch (UnknownHostException unknownHostException) {
                    unknownHostException.printStackTrace();
                }
            } else {
                this.warnMessage();
            }
        }
    }

    private void ListSend() {
        if (modeFrame.debugEnabled()) {
            System.out.println("list ");
        }
        ParamPacket paramPacket = new ParamPacket(2);
        short s = this.num_rfp_packets;
        this.num_rfp_packets = (short)(s + 1);
        paramPacket.setIdent(s);
        paramPacket.setDestinationMac(this.macadr.getText());
        byte[] byArray = new byte[]{-1, -1, -1, -1};
        try {
            InetAddress inetAddress = InetAddress.getByAddress(byArray);
            if (this.ipadrcheck.isSelected()) {
                try {
                    inetAddress = InetAddress.getByName(this.ipadr.getText());
                }
                catch (UnknownHostException unknownHostException) {
                    modeFrame.statusbar.Error("Unknown host: '" + this.ipadr.getText() + "'");
                    return;
                }
            }
            boolean bl = !this.ipadrcheck.isSelected();
            if (this.num_rfp_packets > 1 && this.n_thread.isAlive()) {
                modeFrame.statusbar.Warning("busy: no list send");
            } else {
                this.n_thread = new NetworkThread(modeFrame.debugEnabled());
                this.n_thread.setSendParam(inetAddress, paramPacket, bl);
                this.n_thread.start();
                this.net_action = 2;
                if (this.timer == null) {
                    this.timer = new Timer(200, this.taskPerformer);
                }
                this.timer.start();
                modeFrame.statusbar.Info("send list command to \"" + this.macadr.getText() + "\"");
            }
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
        }
    }

    private void setListParams(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\u0000");
        String string2 = new String("");
        String string3 = new String("");
        this.removeDataValueFlags();
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string4, "=");
            if (stringTokenizer2.hasMoreTokens()) {
                string2 = stringTokenizer2.nextToken();
            }
            if (this.setDataValue(string2, string3 = stringTokenizer2.hasMoreTokens() ? stringTokenizer2.nextToken() : new String(" "))) continue;
            this.param_pnl.addParameter(string2);
            this.setDataValue(string2, string3);
        }
        this.removeAllUnsetRows();
    }

    private boolean testMacAddress() {
        String string = this.macadr.getText();
        return string.length() == 17 && (string.charAt(2) == '-' && string.charAt(5) == '-' && string.charAt(8) == '-' && string.charAt(11) == '-' && string.charAt(14) == '-' || string.charAt(2) == ':' && string.charAt(5) == ':' && string.charAt(8) == ':' && string.charAt(11) == ':' && string.charAt(14) == ':');
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("LIST_CONF")) {
            if (this.testMacAddress()) {
                this.ListSend();
            } else {
                modeFrame.statusbar.Warning("Invalid MAC address: " + this.macadr.getText());
                if (modeFrame.debugEnabled()) {
                    System.out.println("Invalid MAC address: " + this.macadr.getText());
                }
            }
        }
    }

    private boolean setDataValue(String string, String string2) {
        for (int i = 0; i < DataObj.config_data.size(); ++i) {
            DataObj dataObj = (DataObj)DataObj.config_data.elementAt(i);
            String string3 = dataObj.getName();
            if (!string3.equals(string)) continue;
            dataObj.setValue(string2);
            if (!this.param_pnl.isShown(string3)) {
                this.param_pnl.addParameter(string);
                return false;
            }
            return true;
        }
        return false;
    }

    private void removeDataValueFlags() {
        for (int i = 0; i < DataObj.config_data.size(); ++i) {
            ((DataObj)DataObj.config_data.elementAt(i)).removeValueFlag();
        }
    }

    private void removeAllUnsetRows() {
        for (int i = 0; i < DataObj.config_data.size(); ++i) {
            DataObj dataObj = (DataObj)DataObj.config_data.elementAt(i);
            if (dataObj.isValue()) continue;
            dataObj.removeValue();
            if (dataObj.isRequired()) continue;
            this.param_pnl.removeParameter(dataObj.getName());
            --i;
        }
    }
}

